/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.propertyvalue.ICSSValue;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CSSValue
implements ICSSValue {
    public static final boolean DEFAULT_CONSISTENCY_CHECKS_ENABLED = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSValue.class);
    private static boolean s_bConsistencyChecksEnabled = true;
    private ICSSProperty m_aProperty;
    private String m_sValue;
    private boolean m_bIsImportant;

    public static boolean areConsistencyChecksEnabled() {
        return s_bConsistencyChecksEnabled;
    }

    public static void setConsistencyChecksEnabled(boolean bl) {
        s_bConsistencyChecksEnabled = bl;
    }

    public CSSValue(@NonNull ICSSProperty iCSSProperty, @NonNull String string, boolean bl) {
        this.setProperty(iCSSProperty);
        this.setValue(string);
        this.setImportant(bl);
    }

    public @NonNull ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Override
    public @NonNull ECSSProperty getProp() {
        return this.m_aProperty.getProp();
    }

    @Nonempty
    public @NonNull String getPropertyName() {
        return this.m_aProperty.getPropertyName();
    }

    public @NonNull CSSValue setProperty(@NonNull ICSSProperty iCSSProperty) {
        this.m_aProperty = (ICSSProperty)ValueEnforcer.notNull((Object)iCSSProperty, (String)"Property");
        return this;
    }

    public @NonNull String getValue() {
        return this.m_sValue;
    }

    public @NonNull CSSValue setValue(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        if (CSSValue.areConsistencyChecksEnabled()) {
            if (!this.m_aProperty.isValidValue(string)) {
                LOGGER.warn("CSS: the value '" + string + "' is not valid for property '" + this.m_aProperty.getPropertyName() + "'");
            }
            if (string.contains(" !important")) {
                LOGGER.warn("CSS: the value '" + string + "' should not contain the ' !important' string! Use 'setImportant' method instead.");
            }
        }
        this.m_sValue = string.trim();
        return this;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    public @NonNull CSSValue setImportant(boolean bl) {
        this.m_bIsImportant = bl;
        return this;
    }

    @Override
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_aProperty.getPropertyName() + ":" + this.m_sValue + (StringHelper.isNotEmpty((String)this.m_sValue) && this.m_bIsImportant ? " !important" : "") + ";";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValue cSSValue = (CSSValue)object;
        return this.m_aProperty.getProp().equals((Object)cSSValue.m_aProperty.getProp()) && this.m_sValue.equals(cSSValue.m_sValue) && this.m_bIsImportant == cSSValue.m_bIsImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aProperty.getProp()).append((Object)this.m_sValue).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_aProperty).append("value", (Object)this.m_sValue).append("important", this.m_bIsImportant).getToString();
    }
}

