/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public abstract class AbstractCSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public AbstractCSSPropertyEnums(@NonNull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, stringArray);
        ValueEnforcer.isGT0((int)n, (String)"MinArgCount");
        ValueEnforcer.isGT0((int)n2, (String)"MaxArgCount");
        ValueEnforcer.isTrue((n <= n2 ? 1 : 0) != 0, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    public AbstractCSSPropertyEnums(@NonNull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonempty @NonNull Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, iterable);
        ValueEnforcer.isGT0((int)n, (String)"MinArgCount");
        ValueEnforcer.isGT0((int)n2, (String)"MaxArgCount");
        ValueEnforcer.isTrue((n <= n2 ? 1 : 0) != 0, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    @Override
    public final int getMinimumArgumentCount() {
        return this.m_nMinArgCount;
    }

    @Override
    public final int getMaximumArgumentCount() {
        return this.m_nMaxArgCount;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractCSSPropertyEnums abstractCSSPropertyEnums = (AbstractCSSPropertyEnums)object;
        return this.m_nMinArgCount == abstractCSSPropertyEnums.m_nMinArgCount && this.m_nMaxArgCount == abstractCSSPropertyEnums.m_nMaxArgCount;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_nMinArgCount).append(this.m_nMaxArgCount).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("MinArgCount", this.m_nMinArgCount).append("MaxArgCount", this.m_nMaxArgCount).getToString();
    }
}

