/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSelectorMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSSelectorSimpleMember
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorSimpleMember(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        this.m_sValue = string;
    }

    @Nonempty
    public @NonNull String getValue() {
        return this.m_sValue;
    }

    public boolean isElementName() {
        return !this.isHash() && !this.isClass() && !this.isPseudo();
    }

    public boolean isHash() {
        return this.m_sValue.charAt(0) == '#';
    }

    public boolean isClass() {
        return this.m_sValue.charAt(0) == '.';
    }

    public boolean isPseudo() {
        return this.m_sValue.charAt(0) == ':';
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sValue;
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorSimpleMember cSSSelectorSimpleMember = (CSSSelectorSimpleMember)object;
        return this.m_sValue.equals(cSSSelectorSimpleMember.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

