/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.ICSSSelectorMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSSelectorMemberFunctionLike
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sFuncName;
    private final CSSExpression m_aParamExpr;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberFunctionLike(@Nonempty @NonNull String string, @NonNull CSSExpression cSSExpression) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FunctionName");
        if (!string.endsWith("(")) {
            throw new IllegalArgumentException("function name must end with a '('");
        }
        ValueEnforcer.notNull((Object)cSSExpression, (String)"ParameterExpression");
        this.m_sFuncName = string;
        this.m_aParamExpr = cSSExpression;
    }

    @Nonempty
    public @NonNull String getFunctionName() {
        return this.m_sFuncName;
    }

    public @NonNull CSSExpression getParameterExpression() {
        return this.m_aParamExpr;
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sFuncName + this.m_aParamExpr.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = (CSSSelectorMemberFunctionLike)object;
        return this.m_sFuncName.equals(cSSSelectorMemberFunctionLike.m_sFuncName) && this.m_aParamExpr.equals(cSSSelectorMemberFunctionLike.m_aParamExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFuncName).append((Object)this.m_aParamExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("functionName", (Object)this.m_sFuncName).append("paramExpr", (Object)this.m_aParamExpr).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

