/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSelectorMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSSelector
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSSelectorMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return this.m_aMembers.isNotEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    public @NonNull CSSSelector addMember(@NonNull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"Member");
        this.m_aMembers.add((Object)iCSSSelectorMember);
        return this;
    }

    public @NonNull CSSSelector addMember(@Nonnegative int n, @NonNull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add((Object)iCSSSelectorMember);
        } else {
            this.m_aMembers.add(n, (Object)iCSSSelectorMember);
        }
        return this;
    }

    public @NonNull EChange removeMember(@NonNull ICSSSelectorMember iCSSSelectorMember) {
        return this.m_aMembers.removeObject((Object)iCSSSelectorMember);
    }

    public @NonNull EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    public @NonNull EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    public @Nullable ICSSSelectorMember getMemberAtIndex(@Nonnegative int n) {
        return (ICSSSelectorMember)this.m_aMembers.getAtIndex(n);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ICSSSelectorMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Override
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return StringImplode.getImplodedMapped(this.m_aMembers, iCSSSelectorMember -> iCSSSelectorMember.getAsCSSString(iCSSWriterSettings, n));
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelector cSSSelector = (CSSSelector)object;
        return this.m_aMembers.equals(cSSSelector.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

