/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class CSSRect
implements ICSSWriteable {
    private String m_sTop;
    private String m_sRight;
    private String m_sBottom;
    private String m_sLeft;

    public CSSRect(@NonNull CSSRect cSSRect) {
        this(cSSRect.getTop(), cSSRect.getRight(), cSSRect.getBottom(), cSSRect.getLeft());
    }

    public CSSRect(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, @Nonempty @NonNull String string4) {
        this.setTop(string);
        this.setRight(string2);
        this.setBottom(string3);
        this.setLeft(string4);
    }

    @Nonempty
    public final @NonNull String getTop() {
        return this.m_sTop;
    }

    public final @NonNull CSSRect setTop(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Top");
        this.m_sTop = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getRight() {
        return this.m_sRight;
    }

    public final @NonNull CSSRect setRight(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Right");
        this.m_sRight = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getBottom() {
        return this.m_sBottom;
    }

    public final @NonNull CSSRect setBottom(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Bottom");
        this.m_sBottom = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getLeft() {
        return this.m_sLeft;
    }

    public final @NonNull CSSRect setLeft(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Left");
        this.m_sLeft = string;
        return this;
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return "rect(" + this.m_sTop + "," + this.m_sRight + "," + this.m_sBottom + "," + this.m_sLeft + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSRect cSSRect = (CSSRect)object;
        return this.m_sTop.equals(cSSRect.m_sTop) && this.m_sRight.equals(cSSRect.m_sRight) && this.m_sBottom.equals(cSSRect.m_sBottom) && this.m_sLeft.equals(cSSRect.m_sLeft);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sTop).append((Object)this.m_sRight).append((Object)this.m_sBottom).append((Object)this.m_sLeft).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Top", (Object)this.m_sTop).append("Right", (Object)this.m_sRight).append("Bottom", (Object)this.m_sBottom).append("Left", (Object)this.m_sLeft).getToString();
    }
}

