/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.decl.IHasCSSDeclarations;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CSSPageMarginBlock
implements ICSSPageRuleMember,
IHasCSSDeclarations<CSSPageMarginBlock> {
    private String m_sPageMarginSymbol;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public CSSPageMarginBlock(@Nonempty @NonNull String string) {
        this.setPageMarginSymbol(string);
    }

    @Nonempty
    public final @NonNull String getPageMarginSymbol() {
        return this.m_sPageMarginSymbol;
    }

    public final @NonNull CSSPageMarginBlock setPageMarginSymbol(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PargeMarginSymbol");
        ValueEnforcer.isTrue((boolean)StringHelper.startsWith((CharSequence)string, (char)'@'), (String)"Page margin symbol does not start with '@'!");
        this.m_sPageMarginSymbol = string;
        return this;
    }

    @Override
    public @NonNull CSSPageMarginBlock addDeclaration(@NonNull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    public @NonNull CSSPageMarginBlock addDeclaration(@Nonnegative int n, @NonNull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    public @NonNull EChange removeDeclaration(@NonNull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    public @NonNull EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    public @NonNull EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    public @Nullable CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    public @NonNull CSSPageMarginBlock setDeclarationAtIndex(@Nonnegative int n, @NonNull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    public @Nullable CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_sPageMarginSymbol);
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        return stringBuilder.toString();
    }

    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSPageMarginBlock cSSPageMarginBlock = (CSSPageMarginBlock)object;
        return this.m_sPageMarginSymbol.equals(cSSPageMarginBlock.m_sPageMarginSymbol) && this.m_aDeclarations.equals(cSSPageMarginBlock.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPageMarginSymbol).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("pageMarginSymbol", (Object)this.m_sPageMarginSymbol).append("declarations", (Object)this.m_aDeclarations).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

