/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSHSLA;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class CSSHSL
implements ICSSWriteable,
ICSSColor,
ICloneable<CSSHSL> {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;

    public CSSHSL(@NonNull CSSHSL cSSHSL) {
        this(cSSHSL.getHue(), cSSHSL.getSaturation(), cSSHSL.getLightness());
    }

    public CSSHSL(int n, int n2, int n3) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(n)), Integer.toString(CSSColorHelper.getHSLPercentageValue(n2)) + "%", Integer.toString(CSSColorHelper.getHSLPercentageValue(n3)) + "%");
    }

    public CSSHSL(float f, float f2, float f3) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(f)), Float.toString(CSSColorHelper.getHSLPercentageValue(f2)) + "%", Float.toString(CSSColorHelper.getHSLPercentageValue(f3)) + "%");
    }

    public CSSHSL(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3) {
        this.setHue(string);
        this.setSaturation(string2);
        this.setLightness(string3);
    }

    @Nonempty
    public final @NonNull String getHue() {
        return this.m_sHue;
    }

    public final @NonNull CSSHSL setHue(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Hue");
        this.m_sHue = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getSaturation() {
        return this.m_sSaturation;
    }

    public final @NonNull CSSHSL setSaturation(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Saturation");
        this.m_sSaturation = string;
        return this;
    }

    @Nonempty
    public final @NonNull String getLightness() {
        return this.m_sLightness;
    }

    public final @NonNull CSSHSL setLightness(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Lightness");
        this.m_sLightness = string;
        return this;
    }

    public @NonNull CSSHSLA getAsHSLA(float f) {
        return new CSSHSLA(this, f);
    }

    public @NonNull CSSHSLA getAsHSLA(@Nonempty @NonNull String string) {
        return new CSSHSLA(this, string);
    }

    @Override
    @Nonempty
    public @NonNull String getAsString() {
        return "hsl(" + this.m_sHue + "," + this.m_sSaturation + "," + this.m_sLightness + ")";
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.getAsString();
    }

    public @NonNull CSSHSL getClone() {
        return new CSSHSL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSHSL cSSHSL = (CSSHSL)object;
        return this.m_sHue.equals(cSSHSL.m_sHue) && this.m_sSaturation.equals(cSSHSL.m_sSaturation) && this.m_sLightness.equals(cSSHSL.m_sLightness);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHue).append((Object)this.m_sSaturation).append((Object)this.m_sLightness).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Hue", (Object)this.m_sHue).append("Saturation", (Object)this.m_sSaturation).append("Lightness", (Object)this.m_sLightness).getToString();
    }
}

