/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSExpressionMemberLineNames
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberLineNames() {
    }

    public CSSExpressionMemberLineNames(@NonNull Iterable<? extends String> iterable) {
        this.m_aMembers.addAll(iterable);
    }

    public @NonNull CSSExpressionMemberLineNames addMember(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Member");
        this.m_aMembers.add((Object)string);
        return this;
    }

    public @NonNull CSSExpressionMemberLineNames addMember(@Nonnegative int n, @Nonempty @NonNull String string) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)string, (String)"Member");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add((Object)string);
        } else {
            this.m_aMembers.add(n, (Object)string);
        }
        return this;
    }

    public @NonNull EChange removeMember(@NonNull String string) {
        return this.m_aMembers.removeObject((Object)string);
    }

    public @NonNull EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    public @NonNull EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<String> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    public @NonNull CSSExpressionMemberLineNames getClone() {
        return new CSSExpressionMemberLineNames((Iterable<? extends String>)this.m_aMembers);
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl = true;
        for (String string : this.m_aMembers) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberLineNames cSSExpressionMemberLineNames = (CSSExpressionMemberLineNames)object;
        return this.m_aMembers.equals(cSSExpressionMemberLineNames.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

