/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSTopLevelRule;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public abstract class AbstractHasTopLevelRules {
    protected final ICommonsList<ICSSTopLevelRule> m_aRules = new CommonsArrayList();

    public boolean hasRules() {
        return this.m_aRules.isNotEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    public @Nullable ICSSTopLevelRule getRuleAtIndex(@Nonnegative int n) {
        return (ICSSTopLevelRule)this.m_aRules.getAtIndex(n);
    }

    public @NonNull AbstractHasTopLevelRules addRule(@NonNull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        this.m_aRules.add((Object)iCSSTopLevelRule);
        return this;
    }

    public @NonNull AbstractHasTopLevelRules addRule(@Nonnegative int n, @NonNull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        if (n >= this.getRuleCount()) {
            this.m_aRules.add((Object)iCSSTopLevelRule);
        } else {
            this.m_aRules.add(n, (Object)iCSSTopLevelRule);
        }
        return this;
    }

    public @NonNull EChange removeRule(@Nullable ICSSTopLevelRule iCSSTopLevelRule) {
        return this.m_aRules.removeObject((Object)iCSSTopLevelRule);
    }

    public @NonNull EChange removeRule(@Nonnegative int n) {
        return this.m_aRules.removeAtIndex(n);
    }

    public @NonNull EChange removeRules(@NonNull Predicate<? super ICSSTopLevelRule> predicate) {
        return EChange.valueOf((boolean)this.m_aRules.removeIf(predicate));
    }

    public @NonNull EChange removeAllRules() {
        return this.m_aRules.removeAll();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ICSSTopLevelRule> getAllRules() {
        return (ICommonsList)this.m_aRules.getClone();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ICSSTopLevelRule> getAllRules(@NonNull Predicate<? super ICSSTopLevelRule> predicate) {
        return this.m_aRules.getAll(predicate);
    }

    public boolean hasStyleRules() {
        return this.m_aRules.containsAny(CSSStyleRule.class::isInstance);
    }

    @Nonnegative
    public int getStyleRuleCount() {
        return this.m_aRules.getCount(CSSStyleRule.class::isInstance);
    }

    public @Nullable CSSStyleRule getStyleRuleAtIndex(@Nonnegative int n) {
        return (CSSStyleRule)this.m_aRules.getAtIndexMapped(CSSStyleRule.class::isInstance, n, CSSStyleRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSStyleRule> getAllStyleRules() {
        return this.m_aRules.getAllMapped(CSSStyleRule.class::isInstance, CSSStyleRule.class::cast);
    }

    public boolean hasPageRules() {
        return this.m_aRules.containsAny(CSSPageRule.class::isInstance);
    }

    @Nonnegative
    public int getPageRuleCount() {
        return this.m_aRules.getCount(CSSPageRule.class::isInstance);
    }

    public @Nullable CSSPageRule getPageRuleAtIndex(@Nonnegative int n) {
        return (CSSPageRule)this.m_aRules.getAtIndexMapped(CSSPageRule.class::isInstance, n, CSSPageRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSPageRule> getAllPageRules() {
        return this.m_aRules.getAllMapped(CSSPageRule.class::isInstance, CSSPageRule.class::cast);
    }

    public boolean hasMediaRules() {
        return this.m_aRules.containsAny(CSSMediaRule.class::isInstance);
    }

    @Nonnegative
    public int getMediaRuleCount() {
        return this.m_aRules.getCount(CSSMediaRule.class::isInstance);
    }

    public @Nullable CSSMediaRule getMediaRuleAtIndex(@Nonnegative int n) {
        return (CSSMediaRule)this.m_aRules.getAtIndexMapped(CSSMediaRule.class::isInstance, n, CSSMediaRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSMediaRule> getAllMediaRules() {
        return this.m_aRules.getAllMapped(CSSMediaRule.class::isInstance, CSSMediaRule.class::cast);
    }

    public boolean hasFontFaceRules() {
        return this.m_aRules.containsAny(CSSFontFaceRule.class::isInstance);
    }

    @Nonnegative
    public int getFontFaceRuleCount() {
        return this.m_aRules.getCount(CSSFontFaceRule.class::isInstance);
    }

    public @Nullable CSSFontFaceRule getFontFaceRuleAtIndex(@Nonnegative int n) {
        return (CSSFontFaceRule)this.m_aRules.getAtIndexMapped(CSSFontFaceRule.class::isInstance, n, CSSFontFaceRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSFontFaceRule> getAllFontFaceRules() {
        return this.m_aRules.getAllMapped(CSSFontFaceRule.class::isInstance, CSSFontFaceRule.class::cast);
    }

    public boolean hasKeyframesRules() {
        return this.m_aRules.containsAny(CSSKeyframesRule.class::isInstance);
    }

    @Nonnegative
    public int getKeyframesRuleCount() {
        return this.m_aRules.getCount(CSSKeyframesRule.class::isInstance);
    }

    public @Nullable CSSKeyframesRule getKeyframesRuleAtIndex(@Nonnegative int n) {
        return (CSSKeyframesRule)this.m_aRules.getAtIndexMapped(CSSKeyframesRule.class::isInstance, n, CSSKeyframesRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSKeyframesRule> getAllKeyframesRules() {
        return this.m_aRules.getAllMapped(CSSKeyframesRule.class::isInstance, CSSKeyframesRule.class::cast);
    }

    public boolean hasViewportRules() {
        return this.m_aRules.containsAny(CSSViewportRule.class::isInstance);
    }

    @Nonnegative
    public int getViewportRuleCount() {
        return this.m_aRules.getCount(CSSViewportRule.class::isInstance);
    }

    public @Nullable CSSViewportRule getViewportRuleAtIndex(@Nonnegative int n) {
        return (CSSViewportRule)this.m_aRules.getAtIndexMapped(CSSViewportRule.class::isInstance, n, CSSViewportRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSViewportRule> getAllViewportRules() {
        return this.m_aRules.getAllMapped(CSSViewportRule.class::isInstance, CSSViewportRule.class::cast);
    }

    public boolean hasSupportsRules() {
        return this.m_aRules.containsAny(CSSSupportsRule.class::isInstance);
    }

    @Nonnegative
    public int getSupportsRuleCount() {
        return this.m_aRules.getCount(CSSSupportsRule.class::isInstance);
    }

    public @Nullable CSSSupportsRule getSupportsRuleAtIndex(@Nonnegative int n) {
        return (CSSSupportsRule)this.m_aRules.getAtIndexMapped(CSSSupportsRule.class::isInstance, n, CSSSupportsRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSSupportsRule> getAllSupportsRules() {
        return this.m_aRules.getAllMapped(CSSSupportsRule.class::isInstance, CSSSupportsRule.class::cast);
    }

    public boolean hasUnknownRules() {
        return this.m_aRules.containsAny(CSSUnknownRule.class::isInstance);
    }

    @Nonnegative
    public int getUnknownRuleCount() {
        return this.m_aRules.getCount(CSSUnknownRule.class::isInstance);
    }

    public @Nullable CSSUnknownRule getUnknownRuleAtIndex(@Nonnegative int n) {
        return (CSSUnknownRule)this.m_aRules.getAtIndexMapped(CSSUnknownRule.class::isInstance, n, CSSUnknownRule.class::cast);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSUnknownRule> getAllUnknownRules() {
        return this.m_aRules.getAllMapped(CSSUnknownRule.class::isInstance, CSSUnknownRule.class::cast);
    }
}

