/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.annotation.Nonempty;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.string.StringHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ECSSVendorPrefix implements IHasDisplayName
{
    APPLE("-apple-", "Safari"),
    ATSC("-atsc-", "Advanced Television Standards Committee"),
    EPUB("-epub-", "EPUB"),
    KHTML("-khtml-", "Konqueror browser"),
    MICROSOFT("-ms-", "Microsoft"),
    MICROSOFT_OFFICE("mso-", "Microsoft Office"),
    MOZILLA("-moz-", "Mozilla"),
    OPERA("-o-", "Opera"),
    SCROLLBAR("scrollbar-", "Scrollbars"),
    WAP("-wap-", "The WAP forum"),
    WEBKIT("-webkit-", "WebKit-based browsers");

    private final String m_sPrefix;
    private final String m_sDisplayName;

    private ECSSVendorPrefix(String string2, String string3) {
        this.m_sPrefix = string2;
        this.m_sDisplayName = string3;
    }

    @Nonempty
    public @NonNull String getPrefix() {
        return this.m_sPrefix;
    }

    @Nonempty
    public @NonNull String getDisplayName() {
        return this.m_sDisplayName;
    }

    public static @Nullable ECSSVendorPrefix getFromPrefixOrNull(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (ECSSVendorPrefix eCSSVendorPrefix : ECSSVendorPrefix.values()) {
                if (!eCSSVendorPrefix.m_sPrefix.equals(string)) continue;
                return eCSSVendorPrefix;
            }
        }
        return null;
    }
}

