/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceArea;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class CSSSourceLocation {
    private final CSSSourceArea m_aFirstTokenArea;
    private final CSSSourceArea m_aLastTokenArea;

    public CSSSourceLocation(@Nullable CSSSourceArea cSSSourceArea, @Nullable CSSSourceArea cSSSourceArea2) {
        ValueEnforcer.isFalse((cSSSourceArea == null && cSSSourceArea2 == null ? 1 : 0) != 0, (String)"At least one of the areas must be set!");
        this.m_aFirstTokenArea = cSSSourceArea;
        this.m_aLastTokenArea = cSSSourceArea2;
    }

    public @Nullable CSSSourceArea getFirstTokenArea() {
        return this.m_aFirstTokenArea;
    }

    public boolean hasFirstTokenArea() {
        return this.m_aFirstTokenArea != null;
    }

    @CheckForSigned
    public int getFirstTokenBeginLineNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenBeginLineNumber();
    }

    @CheckForSigned
    public int getFirstTokenBeginColumnNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenBeginColumnNumber();
    }

    @CheckForSigned
    public int getFirstTokenEndLineNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenEndLineNumber();
    }

    @CheckForSigned
    public int getFirstTokenEndColumnNumber() {
        return this.m_aFirstTokenArea == null ? -1 : this.m_aFirstTokenArea.getTokenEndColumnNumber();
    }

    public @Nullable CSSSourceArea getLastTokenArea() {
        return this.m_aLastTokenArea;
    }

    public boolean hasLastTokenArea() {
        return this.m_aLastTokenArea != null;
    }

    @CheckForSigned
    public int getLastTokenBeginLineNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenBeginLineNumber();
    }

    @CheckForSigned
    public int getLastTokenBeginColumnNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenBeginColumnNumber();
    }

    @CheckForSigned
    public int getLastTokenEndLineNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenEndLineNumber();
    }

    @CheckForSigned
    public int getLastTokenEndColumnNumber() {
        return this.m_aLastTokenArea == null ? -1 : this.m_aLastTokenArea.getTokenEndColumnNumber();
    }

    public @Nullable String getFirstTokenLocationAsString() {
        return this.m_aFirstTokenArea == null ? null : this.m_aFirstTokenArea.getTokenLocationAsString();
    }

    public @Nullable String getLastTokenLocationAsString() {
        return this.m_aLastTokenArea == null ? null : this.m_aLastTokenArea.getTokenLocationAsString();
    }

    @Nonempty
    public @NonNull String getLocationAsString() {
        String string = this.getFirstTokenLocationAsString();
        String string2 = this.getLastTokenLocationAsString();
        return StringHelper.getNotNull((String)string, (String)"") + "-" + StringHelper.getNotNull((String)string2, (String)"");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSourceLocation cSSSourceLocation = (CSSSourceLocation)object;
        return EqualsHelper.equals((Object)this.m_aFirstTokenArea, (Object)cSSSourceLocation.m_aFirstTokenArea) && EqualsHelper.equals((Object)this.m_aLastTokenArea, (Object)cSSSourceLocation.m_aLastTokenArea);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aFirstTokenArea).append((Object)this.m_aLastTokenArea).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("firstTokenArea", (Object)this.m_aFirstTokenArea).append("lastTokenArea", (Object)this.m_aLastTokenArea).getToString();
    }
}

