/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.annotation.Nonempty;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.ParserCSS30TreeConstants;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2),
    CHARSET(15),
    UNKNOWNRULE(72),
    UNKNOWNRULEPARAMETERLIST(70),
    UNKNOWNRULEBODY(71),
    STYLERULE(43),
    IMPORTRULE(16),
    PAGERULE(54),
    MEDIARULE(50),
    LAYERRULE(58),
    FONTFACERULE(59),
    SELECTOR(38),
    RELATIVESELECTOR(31),
    STYLEDECLARATIONLIST(42),
    STYLEDECLARATION(41),
    NAMESPACEPREFIX(20),
    ELEMENTNAME(21),
    HASH(22),
    CLASS(23),
    PSEUDO(35),
    HOST(28),
    HOSTCONTEXT(29),
    SLOTTED(30),
    NEGATION(36),
    PSEUDO_HAS(32),
    PSEUDO_IS(33),
    PSEUDO_WHERE(34),
    ATTRIB(26),
    ATTRIBOPERATOR(24),
    ATTRIBVALUE(25),
    SELECTORCOMBINATOR(37),
    NTH(27),
    PROPERTY(39),
    IMPORTANT(40),
    EXPR(14),
    EXPRTERM(12),
    EXPROPERATOR(13),
    URL(3),
    FUNCTION(4),
    CALC(9),
    CALCSUMOPERATOR(8),
    CALCPRODUCT(7),
    CALCPRODUCTOPERATOR(6),
    CALCUNIT(5),
    LINE_NAMES(11),
    LINE_NAME(10),
    MEDIALIST(49),
    MEDIUM(45),
    MEDIAQUERY(48),
    MEDIAMODIFIER(44),
    MEDIAEXPR(47),
    MEDIAFEATURE(46),
    LAYERSELECTOR(55),
    LAYERSELECTORLIST(56),
    LAYERRULEBLOCK(57),
    PSEUDOPAGE(-1),
    PAGESELECTOR(51),
    PAGEMARGINSYMBOL(52),
    PAGERULEBLOCK(53),
    KEYFRAMESRULE(63),
    KEYFRAMESIDENTIFIER(60),
    KEYFRAMESSELECTOR(62),
    SINGLEKEYFRAMESELECTOR(61),
    VIEWPORTRULE(64),
    NAMESPACERULE(19),
    NAMESPACERULEPREFIX(17),
    NAMESPACERULEURL(18),
    SUPPORTSRULE(69),
    SUPPORTSCONDITION(68),
    SUPPORTSCONDITIONOPERATOR(67),
    SUPPORTSNEGATION(66),
    SUPPORTSCONDITIONINPARENS(65),
    ERROR_SKIPTO(1);

    private static final Logger LOGGER;
    private final int m_nParserType30;

    private ECSSNodeType(int n2) {
        this.m_nParserType30 = n2;
    }

    int getParserNodeType() {
        return this.m_nParserType30;
    }

    public boolean isNode(@Nonnull CSSNode cSSNode) {
        return cSSNode.getNodeType() == this.getParserNodeType();
    }

    @Nonnull
    String getNodeName() {
        return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode cSSNode) {
        for (ECSSNodeType eCSSNodeType : ECSSNodeType.values()) {
            if (!eCSSNodeType.isNode(cSSNode)) continue;
            return eCSSNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode cSSNode) {
        ECSSNodeType eCSSNodeType = ECSSNodeType.getNodeType(cSSNode);
        if (eCSSNodeType != null) {
            return eCSSNodeType.getNodeName();
        }
        LOGGER.warn("Unsupported node type " + cSSNode.getNodeType());
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode cSSNode, @Nonnull StringBuilder stringBuilder, @Nonnull String string) {
        stringBuilder.append(string).append(ECSSNodeType.getNodeName(cSSNode));
        if (cSSNode.isNotEmpty()) {
            stringBuilder.append('[').append(cSSNode.getText()).append(']');
        }
        stringBuilder.append('\n');
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ECSSNodeType._dumpRecursive(cSSNode2, stringBuilder, string + "  ");
        }
    }

    @Nonnull
    @Nonempty
    public static String getDump(@Nonnull CSSNode cSSNode) {
        StringBuilder stringBuilder = new StringBuilder();
        ECSSNodeType._dumpRecursive(cSSNode, stringBuilder, "");
        return stringBuilder.toString();
    }

    public static boolean isErrorNode(@Nonnull CSSNode cSSNode) {
        return ERROR_SKIPTO.isNode(cSSNode);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

