/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberFunction;
import com.helger.css.decl.CSSExpressionMemberLineNames;
import com.helger.css.decl.CSSExpressionMemberMath;
import com.helger.css.decl.CSSExpressionMemberMathProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitSimple;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSLayerRule;
import com.helger.css.decl.CSSMediaExpression;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageMarginBlock;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSSelectorAttribute;
import com.helger.css.decl.CSSSelectorMemberFunctionLike;
import com.helger.css.decl.CSSSelectorMemberHost;
import com.helger.css.decl.CSSSelectorMemberHostContext;
import com.helger.css.decl.CSSSelectorMemberNot;
import com.helger.css.decl.CSSSelectorMemberPseudoHas;
import com.helger.css.decl.CSSSelectorMemberPseudoIs;
import com.helger.css.decl.CSSSelectorMemberPseudoWhere;
import com.helger.css.decl.CSSSelectorMemberSlotted;
import com.helger.css.decl.CSSSelectorSimpleMember;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsConditionDeclaration;
import com.helger.css.decl.CSSSupportsConditionNegation;
import com.helger.css.decl.CSSSupportsConditionNested;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSURI;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ECSSAttributeOperator;
import com.helger.css.decl.ECSSExpressionOperator;
import com.helger.css.decl.ECSSMathOperator;
import com.helger.css.decl.ECSSSelectorCombinator;
import com.helger.css.decl.ECSSSupportsConditionOperator;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSSupportsConditionMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.media.ECSSMediaExpressionFeature;
import com.helger.css.media.ECSSMedium;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.function.Consumer;

@NotThreadSafe
final class CSSNodeToDomainObject {
    private final ICSSInterpretErrorHandler m_aErrorHandler;
    private final boolean m_bUseSourceLocation;

    public CSSNodeToDomainObject(@Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl) {
        this.m_aErrorHandler = (ICSSInterpretErrorHandler)ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"ErrorHandler");
        this.m_bUseSourceLocation = bl;
    }

    private void _expectNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSNodeType eCSSNodeType) {
        if (!eCSSNodeType.isNode(cSSNode)) {
            throw new CSSHandlingException(cSSNode, "Expected a '" + eCSSNodeType.getNodeName() + "' node but received a '" + ECSSNodeType.getNodeName(cSSNode) + "'");
        }
    }

    private void _throwUnexpectedChildrenCount(@Nonnull CSSNode cSSNode, @Nonnull @Nonempty String string) {
        this.m_aErrorHandler.onCSSInterpretationError(string);
        for (int i = 0; i < cSSNode.jjtGetNumChildren(); ++i) {
            this.m_aErrorHandler.onCSSInterpretationError("  " + String.valueOf(cSSNode.jjtGetChild(i)));
        }
        throw new CSSHandlingException(cSSNode, string);
    }

    @Nonnull
    private CSSImportRule _createImportRule(@Nonnull CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.IMPORTRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at last 2 children but got " + n + "!");
        }
        CSSURI cSSURI = null;
        int n2 = 0;
        if (n > 0) {
            object = cSSNode.jjtGetChild(0);
            if (ECSSNodeType.URL.isNode((CSSNode)object)) {
                cSSURI = new CSSURI(((CSSNode)object).getText());
                if (this.m_bUseSourceLocation) {
                    cSSURI.setSourceLocation(((CSSNode)object).getSourceLocation());
                }
                ++n2;
            } else if (!ECSSNodeType.MEDIALIST.isNode((CSSNode)object)) {
                throw new IllegalStateException("Expected an URI or MEDIALIST node but got " + ECSSNodeType.getNodeName((CSSNode)object));
            }
        }
        if (cSSURI == null) {
            cSSURI = new CSSURI(CSSParseHelper.extractStringValue(cSSNode.getText()));
            if (this.m_bUseSourceLocation) {
                cSSURI.setSourceLocation(cSSNode.getSourceLocation());
            }
        }
        object = new CSSImportRule(cSSURI);
        if (this.m_bUseSourceLocation) {
            ((CSSImportRule)object).setSourceLocation(cSSNode.getSourceLocation());
        }
        if (n > n2) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2)) {
                Iterator<CSSNode> iterator = cSSNode2.iterator();
                while (iterator.hasNext()) {
                    CSSNode cSSNode3 = iterator.next();
                    ((CSSImportRule)object).addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                ++n2;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an MEDIALIST node but got " + ECSSNodeType.getNodeName(cSSNode2));
            }
        }
        if (n2 < n) {
            this.m_aErrorHandler.onCSSInterpretationError("Import statement has children which are unhandled.");
        }
        return object;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode cSSNode) {
        CSSSelectorAttribute cSSSelectorAttribute;
        this._expectNodeType(cSSNode, ECSSNodeType.ATTRIB);
        int n = cSSNode.jjtGetNumChildren();
        String string = null;
        int n2 = 0;
        if (n > 0 && ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode.jjtGetChild(0))) {
            string = cSSNode.jjtGetChild(0).getText();
            n2 = 1;
        }
        String string2 = cSSNode.getText();
        if (n == n2) {
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2);
        } else {
            int n3 = n2 + 2;
            if (n != n3) {
                this._throwUnexpectedChildrenCount(cSSNode, "Illegal number of children present (" + n + ") - expected " + n3);
            }
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            this._expectNodeType(cSSNode2, ECSSNodeType.ATTRIBOPERATOR);
            CSSNode cSSNode3 = cSSNode.jjtGetChild(n2 + 1);
            this._expectNodeType(cSSNode3, ECSSNodeType.ATTRIBVALUE);
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2, ECSSAttributeOperator.getFromNameOrNull(cSSNode2.getText()), cSSNode3.getText());
        }
        if (this.m_bUseSourceLocation) {
            cSSSelectorAttribute.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSSelectorAttribute;
    }

    @Nullable
    private ECSSSelectorCombinator _createSelectorCombinator(String string) {
        ECSSSelectorCombinator eCSSSelectorCombinator = ECSSSelectorCombinator.getFromNameOrNull(string);
        if (eCSSSelectorCombinator == null) {
            this.m_aErrorHandler.onCSSInterpretationError("Failed to parse CSS selector combinator '" + string + "'");
        }
        return eCSSSelectorCombinator;
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode) || ECSSNodeType.ELEMENTNAME.isNode(cSSNode) || ECSSNodeType.HASH.isNode(cSSNode) || ECSSNodeType.CLASS.isNode(cSSNode)) {
            if (n != 0) {
                this._throwUnexpectedChildrenCount(cSSNode, "CSS simple selector member expected 0 children and got " + n);
            }
            CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
            if (this.m_bUseSourceLocation) {
                cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSSelectorSimpleMember;
        }
        if (ECSSNodeType.ATTRIB.isNode(cSSNode)) {
            return this._createSelectorAttribute(cSSNode);
        }
        if (ECSSNodeType.SELECTORCOMBINATOR.isNode(cSSNode)) {
            return this._createSelectorCombinator(cSSNode.getText());
        }
        if (ECSSNodeType.NEGATION.isNode(cSSNode)) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (int i = 0; i < n; ++i) {
                CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
                CSSSelector cSSSelector = this._createSelector(cSSNode2);
                commonsArrayList.add((Object)cSSSelector);
            }
            CSSSelectorMemberNot cSSSelectorMemberNot = new CSSSelectorMemberNot((Iterable<CSSSelector>)commonsArrayList);
            if (this.m_bUseSourceLocation) {
                cSSSelectorMemberNot.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSSelectorMemberNot;
        }
        if (ECSSNodeType.PSEUDO.isNode(cSSNode)) {
            if (n == 0) {
                Object object = cSSNode.getText();
                if (((String)object).endsWith("(")) {
                    object = (String)object + ")";
                }
                CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember((String)object);
                if (this.m_bUseSourceLocation) {
                    cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                }
                return cSSSelectorSimpleMember;
            }
            if (n == 1) {
                CSSNode cSSNode3 = cSSNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(cSSNode3)) {
                    CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText() + cSSNode3.getText() + ")");
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorSimpleMember;
                }
                if (ECSSNodeType.HOST.isNode(cSSNode3)) {
                    CSSSelector cSSSelector = new CSSSelector();
                    int n2 = cSSNode3.jjtGetNumChildren();
                    for (int i = 0; i < n2; ++i) {
                        cSSSelector.addMember(this._createSelectorMember(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberHost cSSSelectorMemberHost = new CSSSelectorMemberHost(cSSSelector);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberHost.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberHost;
                }
                if (ECSSNodeType.HOSTCONTEXT.isNode(cSSNode3)) {
                    CSSSelector cSSSelector = new CSSSelector();
                    int n3 = cSSNode3.jjtGetNumChildren();
                    for (int i = 0; i < n3; ++i) {
                        cSSSelector.addMember(this._createSelectorMember(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberHostContext cSSSelectorMemberHostContext = new CSSSelectorMemberHostContext(cSSSelector);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberHostContext.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberHostContext;
                }
                if (ECSSNodeType.SLOTTED.isNode(cSSNode3)) {
                    CSSSelector cSSSelector = new CSSSelector();
                    int n4 = cSSNode3.jjtGetNumChildren();
                    for (int i = 0; i < n4; ++i) {
                        cSSSelector.addMember(this._createSelectorMember(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberSlotted cSSSelectorMemberSlotted = new CSSSelectorMemberSlotted(cSSSelector);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberSlotted.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberSlotted;
                }
                if (ECSSNodeType.PSEUDO_HAS.isNode(cSSNode3)) {
                    int n5 = cSSNode3.jjtGetNumChildren();
                    CommonsArrayList commonsArrayList = new CommonsArrayList();
                    for (int i = 0; i < n5; ++i) {
                        commonsArrayList.add((Object)this._createRelativeSelector(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberPseudoHas cSSSelectorMemberPseudoHas = new CSSSelectorMemberPseudoHas((Iterable<CSSSelector>)commonsArrayList);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberPseudoHas.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberPseudoHas;
                }
                if (ECSSNodeType.PSEUDO_WHERE.isNode(cSSNode3)) {
                    int n6 = cSSNode3.jjtGetNumChildren();
                    CommonsArrayList commonsArrayList = new CommonsArrayList();
                    for (int i = 0; i < n6; ++i) {
                        commonsArrayList.add((Object)this._createSelector(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberPseudoWhere cSSSelectorMemberPseudoWhere = new CSSSelectorMemberPseudoWhere((Iterable<CSSSelector>)commonsArrayList);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberPseudoWhere.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberPseudoWhere;
                }
                if (ECSSNodeType.PSEUDO_IS.isNode(cSSNode3)) {
                    int n7 = cSSNode3.jjtGetNumChildren();
                    CommonsArrayList commonsArrayList = new CommonsArrayList();
                    for (int i = 0; i < n7; ++i) {
                        commonsArrayList.add((Object)this._createSelector(cSSNode3.jjtGetChild(i)));
                    }
                    CSSSelectorMemberPseudoIs cSSSelectorMemberPseudoIs = new CSSSelectorMemberPseudoIs((Iterable<CSSSelector>)commonsArrayList);
                    if (this.m_bUseSourceLocation) {
                        cSSSelectorMemberPseudoIs.setSourceLocation(cSSNode.getSourceLocation());
                    }
                    return cSSSelectorMemberPseudoIs;
                }
                CSSExpression cSSExpression = this._createExpression(cSSNode3);
                CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = new CSSSelectorMemberFunctionLike(cSSNode.getText(), cSSExpression);
                if (this.m_bUseSourceLocation) {
                    cSSSelectorMemberFunctionLike.setSourceLocation(cSSNode.getSourceLocation());
                }
                return cSSSelectorMemberFunctionLike;
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + n + " args: " + cSSNode.toString());
        }
        if (ECSSNodeType.SELECTOR.isNode(cSSNode)) {
            return this._createSelector(cSSNode);
        }
        this.m_aErrorHandler.onCSSInterpretationError("Unsupported selector child: " + ECSSNodeType.getNodeName(cSSNode));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SELECTOR);
        CSSSelector cSSSelector = new CSSSelector();
        if (this.m_bUseSourceLocation) {
            cSSSelector.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ICSSSelectorMember iCSSSelectorMember = this._createSelectorMember(cSSNode2);
            if (iCSSSelectorMember == null) continue;
            cSSSelector.addMember(iCSSSelectorMember);
        }
        return cSSSelector;
    }

    @Nonnull
    private CSSSelector _createRelativeSelector(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.RELATIVESELECTOR);
        CSSSelector cSSSelector = new CSSSelector();
        if (this.m_bUseSourceLocation) {
            cSSSelector.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ICSSSelectorMember iCSSSelectorMember = this._createSelectorMember(cSSNode2);
            if (iCSSSelectorMember == null) continue;
            cSSSelector.addMember(iCSSSelectorMember);
        }
        return cSSSelector;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionCalcProduct(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.CALCPRODUCT);
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = new CSSExpressionMemberMathProduct();
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberMathProduct.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            ICSSExpressionMathMember iCSSExpressionMathMember;
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.CALCUNIT.isNode(cSSNode2)) {
                int n = cSSNode2.jjtGetNumChildren();
                if (n == 0) {
                    iCSSExpressionMathMember = new CSSExpressionMemberMathUnitSimple(cSSNode2.getText());
                    if (this.m_bUseSourceLocation) {
                        ((CSSExpressionMemberMathUnitSimple)iCSSExpressionMathMember).setSourceLocation(cSSNode2.getSourceLocation());
                    }
                    cSSExpressionMemberMathProduct.addMember(iCSSExpressionMathMember);
                    continue;
                }
                if (n == 1 && ECSSNodeType.FUNCTION.isNode(cSSNode2.jjtGetChild(0))) {
                    cSSExpressionMemberMathProduct.addMember(this._createExpressionFunction(cSSNode2.jjtGetChild(0)));
                    continue;
                }
                if (n == 1 && ECSSNodeType.CALC.isNode(cSSNode2.jjtGetChild(0))) {
                    cSSExpressionMemberMathProduct.addMember(this._createExpressionCalc(cSSNode2.jjtGetChild(0)));
                    continue;
                }
                if (n % 2 == 0) {
                    this._throwUnexpectedChildrenCount(cSSNode2, "CSS math unit expected odd child count and got " + n);
                }
                iCSSExpressionMathMember = new CSSExpressionMemberMathProduct();
                for (int i = 0; i < n; ++i) {
                    CSSNode cSSNode3 = cSSNode2.jjtGetChild(i);
                    if (ECSSNodeType.CALCPRODUCT.isNode(cSSNode3)) {
                        ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).addMember(this._createExpressionCalcProduct(cSSNode3));
                        continue;
                    }
                    if (ECSSNodeType.CALCSUMOPERATOR.isNode(cSSNode3)) {
                        String string = cSSNode3.getText();
                        ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                        if (eCSSMathOperator == null) {
                            this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + string + "'");
                            continue;
                        }
                        ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).addMember(eCSSMathOperator);
                        continue;
                    }
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode2) + ": " + ECSSNodeType.getNodeName(cSSNode3));
                }
                if (this.m_bUseSourceLocation) {
                    ((CSSExpressionMemberMathProduct)iCSSExpressionMathMember).setSourceLocation(cSSNode2.getSourceLocation());
                }
                cSSExpressionMemberMathProduct.addMember(new CSSExpressionMemberMathUnitProduct((CSSExpressionMemberMathProduct)iCSSExpressionMathMember));
                continue;
            }
            if (ECSSNodeType.CALCPRODUCTOPERATOR.isNode(cSSNode2)) {
                String string = cSSNode2.getText();
                iCSSExpressionMathMember = ECSSMathOperator.getFromNameOrNull(string);
                if (iCSSExpressionMathMember == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math product operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMathProduct.addMember(iCSSExpressionMathMember);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode) + ": " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSExpressionMemberMathProduct;
    }

    @Nonnull
    private CSSExpressionMemberTermURI _createExpressionURL(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.URL);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 0) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 children but got " + n + "!");
        }
        CSSURI cSSURI = new CSSURI(cSSNode.getText());
        CSSExpressionMemberTermURI cSSExpressionMemberTermURI = new CSSExpressionMemberTermURI(cSSURI);
        if (this.m_bUseSourceLocation) {
            CSSSourceLocation cSSSourceLocation = cSSNode.getSourceLocation();
            cSSURI.setSourceLocation(cSSSourceLocation);
            cSSExpressionMemberTermURI.setSourceLocation(cSSSourceLocation);
        }
        return cSSExpressionMemberTermURI;
    }

    @Nonnull
    private CSSExpressionMemberFunction _createExpressionFunction(@Nonnull CSSNode cSSNode) {
        CSSExpressionMemberFunction cSSExpressionMemberFunction;
        this._expectNodeType(cSSNode, ECSSNodeType.FUNCTION);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        String string = cSSNode.getText();
        if (n == 1) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
            CSSExpression cSSExpression = this._createExpression(cSSNode2);
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string, cSSExpression);
        } else {
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string);
        }
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberFunction.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSExpressionMemberFunction;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionCalc(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.CALC);
        CSSExpressionMemberMath cSSExpressionMemberMath = new CSSExpressionMemberMath();
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberMath.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.CALCPRODUCT.isNode(cSSNode2)) {
                cSSExpressionMemberMath.addMember(this._createExpressionCalcProduct(cSSNode2));
                continue;
            }
            if (ECSSNodeType.CALCSUMOPERATOR.isNode(cSSNode2)) {
                String string = cSSNode2.getText();
                ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                if (eCSSMathOperator == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMath.addMember(eCSSMathOperator);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode) + ": " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSExpressionMemberMath;
    }

    @Nonnull
    private CSSExpressionMemberLineNames _createExpressionLineNamesTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.LINE_NAMES);
        CSSExpressionMemberLineNames cSSExpressionMemberLineNames = new CSSExpressionMemberLineNames();
        if (this.m_bUseSourceLocation) {
            cSSExpressionMemberLineNames.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.LINE_NAME.isNode(cSSNode2)) {
                cSSExpressionMemberLineNames.addMember(cSSNode2.getText());
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode) + ": " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSExpressionMemberLineNames;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPRTERM);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        if (n == 0) {
            CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = new CSSExpressionMemberTermSimple(cSSNode.getText());
            if (this.m_bUseSourceLocation) {
                cSSExpressionMemberTermSimple.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSExpressionMemberTermSimple;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        if (ECSSNodeType.URL.isNode(cSSNode2)) {
            return this._createExpressionURL(cSSNode2);
        }
        if (ECSSNodeType.FUNCTION.isNode(cSSNode2)) {
            return this._createExpressionFunction(cSSNode2);
        }
        if (ECSSNodeType.CALC.isNode(cSSNode2)) {
            return this._createExpressionCalc(cSSNode2);
        }
        if (ECSSNodeType.LINE_NAMES.isNode(cSSNode2)) {
            return this._createExpressionLineNamesTerm(cSSNode2);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(cSSNode2));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPR);
        CSSExpression cSSExpression = new CSSExpression();
        if (this.m_bUseSourceLocation) {
            cSSExpression.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.EXPRTERM.isNode(cSSNode2)) {
                cSSExpression.addMember(this._createExpressionTerm(cSSNode2));
                continue;
            }
            if (ECSSNodeType.EXPROPERATOR.isNode(cSSNode2)) {
                String string = cSSNode2.getText();
                ECSSExpressionOperator eCSSExpressionOperator = ECSSExpressionOperator.getFromNameOrNull(string);
                if (eCSSExpressionOperator == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse expression operator '" + string + "'");
                    continue;
                }
                cSSExpression.addMember(eCSSExpressionOperator);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode) + ": " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSExpression;
    }

    @Nullable
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode cSSNode) {
        Object object;
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATION);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 3) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 1-3 children but got " + n + "!");
        }
        if (n == 1) {
            return null;
        }
        if (!ECSSNodeType.EXPR.isNode(cSSNode.jjtGetChild(1))) {
            return null;
        }
        String string = cSSNode.jjtGetChild(0).getText();
        if (string == null) {
            return null;
        }
        CSSExpression cSSExpression = this._createExpression(cSSNode.jjtGetChild(1));
        boolean bl = false;
        if (n == 3) {
            object = cSSNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode((CSSNode)object)) {
                bl = true;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an " + ECSSNodeType.IMPORTANT.getNodeName() + " token but got a " + ECSSNodeType.getNodeName((CSSNode)object));
            }
        }
        object = new CSSDeclaration(string, cSSExpression, bl);
        if (this.m_bUseSourceLocation) {
            ((CSSDeclaration)object).setSourceLocation(cSSNode.getSourceLocation());
        }
        return object;
    }

    private void _readStyleDeclarationList(@Nonnull CSSNode cSSNode, @Nonnull Consumer<CSSDeclaration> consumer) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATIONLIST);
        int n = cSSNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            CSSDeclaration cSSDeclaration;
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (!ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2) || (cSSDeclaration = this._createDeclaration(cSSNode2)) == null) continue;
            consumer.accept(cSSDeclaration);
        }
    }

    @Nullable
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLERULE);
        CSSStyleRule cSSStyleRule = new CSSStyleRule();
        if (this.m_bUseSourceLocation) {
            cSSStyleRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        boolean bl = true;
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.SELECTOR.isNode(cSSNode2)) {
                if (!bl) {
                    this.m_aErrorHandler.onCSSInterpretationError("Found a selector after a declaration!");
                }
                cSSStyleRule.addSelector(this._createSelector(cSSNode2));
                continue;
            }
            bl = false;
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2)) {
                this._readStyleDeclarationList(cSSNode2, cSSStyleRule::addDeclaration);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode) + ": " + ECSSNodeType.getNodeName(cSSNode2));
        }
        if (cSSStyleRule.getSelectorCount() == 0) {
            return null;
        }
        return cSSStyleRule;
    }

    @Nonnull
    private CSSPageRule _createPageRule(@Nonnull CSSNode cSSNode) {
        CSSNode cSSNode2;
        this._expectNodeType(cSSNode, ECSSNodeType.PAGERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child but got " + n + "!");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (int i = 0; i < n - 1; ++i) {
            cSSNode2 = cSSNode.jjtGetChild(i);
            this._expectNodeType(cSSNode2, ECSSNodeType.PAGESELECTOR);
            commonsArrayList.add((Object)cSSNode2.getText());
        }
        CSSPageRule cSSPageRule = new CSSPageRule((Iterable<String>)commonsArrayList);
        if (this.m_bUseSourceLocation) {
            cSSPageRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        cSSNode2 = cSSNode.jjtGetChild(n - 1);
        this._expectNodeType(cSSNode2, ECSSNodeType.PAGERULEBLOCK);
        int n2 = cSSNode2.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            ICSSPageRuleMember iCSSPageRuleMember;
            CSSNode cSSNode3 = cSSNode2.jjtGetChild(i);
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode3)) {
                iCSSPageRuleMember = this._createDeclaration(cSSNode3);
                if (iCSSPageRuleMember == null) continue;
                cSSPageRule.addMember(iCSSPageRuleMember);
                continue;
            }
            if (ECSSNodeType.PAGEMARGINSYMBOL.isNode(cSSNode3)) {
                iCSSPageRuleMember = new CSSPageMarginBlock(cSSNode3.getText());
                if (this.m_bUseSourceLocation) {
                    ((CSSPageMarginBlock)iCSSPageRuleMember).setSourceLocation(cSSNode3.getSourceLocation());
                }
                CSSNode cSSNode4 = cSSNode2.jjtGetChild(i + 1);
                this._readStyleDeclarationList(cSSNode4, ((CSSPageMarginBlock)iCSSPageRuleMember)::addDeclaration);
                cSSPageRule.addMember(iCSSPageRuleMember);
                ++i;
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode3)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported page rule body child: " + ECSSNodeType.getNodeName(cSSNode3));
        }
        return cSSPageRule;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        if (this.m_bUseSourceLocation) {
            cSSMediaRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            Object object;
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2)) {
                object = cSSNode2.iterator();
                while (object.hasNext()) {
                    CSSNode cSSNode3 = object.next();
                    cSSMediaRule.addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2)) {
                object = this._createStyleRule(cSSNode2);
                if (object == null) continue;
                cSSMediaRule.addRule((ICSSTopLevelRule)object);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.LAYERRULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createLayerRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(cSSNode2)) {
                cSSMediaRule.addRule(this._createUnknownRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media-rule child: " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSMediaRule;
    }

    @Nonnull
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode cSSNode) {
        Object object;
        Object object2;
        if (ECSSNodeType.MEDIUM.isNode(cSSNode)) {
            String string = cSSNode.getText();
            if (ECSSMedium.getFromNameOrNull(string) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS Media query uses unknown medium '" + string + "'");
            }
            CSSMediaQuery cSSMediaQuery = new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, string);
            if (this.m_bUseSourceLocation) {
                cSSMediaQuery.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSMediaQuery;
        }
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAQUERY);
        int n = cSSNode.jjtGetNumChildren();
        int n2 = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (n > 0 && ECSSNodeType.MEDIAMODIFIER.isNode((CSSNode)(object2 = cSSNode.jjtGetChild(0)))) {
            object = ((CSSNode)object2).getText();
            if (object != null) {
                if ("not".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported media modifier '" + (String)object + "' found!");
                }
            }
            ++n2;
        }
        object2 = null;
        if (n > n2 && ECSSNodeType.MEDIUM.isNode((CSSNode)(object = cSSNode.jjtGetChild(n2)))) {
            object2 = ((CSSNode)object).getText();
            if (ECSSMedium.getFromNameOrNull((String)object2) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS media query uses unknown medium '" + (String)object2 + "'");
            }
            ++n2;
        }
        object = new CSSMediaQuery(eModifier, (String)object2);
        if (this.m_bUseSourceLocation) {
            ((CSSMediaQuery)object).setSourceLocation(cSSNode.getSourceLocation());
        }
        for (int i = n2; i < n; ++i) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(cSSNode2)) {
                ((CSSMediaQuery)object).addMediaExpression(this._createMediaExpr(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media query child: " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return object;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode cSSNode) {
        CSSMediaExpression cSSMediaExpression;
        CSSNode cSSNode2;
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAEXPR);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 1 && n != 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 1 or 2 children but got " + n + "!");
        }
        if (!ECSSNodeType.MEDIAFEATURE.isNode(cSSNode2 = cSSNode.jjtGetChild(0))) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(cSSNode2));
        }
        String string = cSSNode2.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(string) == null) {
            this.m_aErrorHandler.onCSSInterpretationWarning("Media expression uses unknown feature '" + string + "'");
        }
        if (n == 1) {
            cSSMediaExpression = new CSSMediaExpression(string);
        } else {
            CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
            cSSMediaExpression = new CSSMediaExpression(string, this._createExpression(cSSNode3));
        }
        if (this.m_bUseSourceLocation) {
            cSSMediaExpression.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSMediaExpression;
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.FONTFACERULE);
        String string = cSSNode.getText();
        CSSFontFaceRule cSSFontFaceRule = new CSSFontFaceRule(string);
        if (this.m_bUseSourceLocation) {
            cSSFontFaceRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2)) {
                this._readStyleDeclarationList(cSSNode2, cSSFontFaceRule::addDeclaration);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSFontFaceRule;
    }

    @Nonnull
    private CSSLayerRule _createLayerRule(@Nonnull CSSNode cSSNode) {
        CSSLayerRule cSSLayerRule;
        this._expectNodeType(cSSNode, ECSSNodeType.LAYERRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child and at last 2 children but got " + n + "!");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (ECSSNodeType.LAYERSELECTORLIST.isNode(cSSNode.jjtGetChild(0))) {
            Iterator<CSSNode> iterator = cSSNode.jjtGetChild(0).iterator();
            while (iterator.hasNext()) {
                CSSNode cSSNode2 = iterator.next();
                this._expectNodeType(cSSNode2, ECSSNodeType.LAYERSELECTOR);
                commonsArrayList.add((Object)cSSNode2.getText());
            }
            cSSLayerRule = new CSSLayerRule((Iterable<String>)commonsArrayList);
        } else {
            if (ECSSNodeType.LAYERSELECTOR.isNode(cSSNode.jjtGetChild(0))) {
                commonsArrayList.add((Object)cSSNode.jjtGetChild(0).getText());
            }
            cSSLayerRule = new CSSLayerRule((Iterable<String>)commonsArrayList);
            CSSNode cSSNode3 = cSSNode.jjtGetChild(n - 1);
            this._expectNodeType(cSSNode3, ECSSNodeType.LAYERRULEBLOCK);
            int n2 = cSSNode3.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                CSSNode cSSNode4 = cSSNode3.jjtGetChild(i);
                if (ECSSNodeType.STYLERULE.isNode(cSSNode4)) {
                    CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode4);
                    if (cSSStyleRule == null) continue;
                    cSSLayerRule.addRule(cSSStyleRule);
                    continue;
                }
                if (ECSSNodeType.LAYERRULE.isNode(cSSNode4)) {
                    cSSLayerRule.addRule(this._createLayerRule(cSSNode4));
                    continue;
                }
                if (ECSSNodeType.MEDIARULE.isNode(cSSNode4)) {
                    cSSLayerRule.addRule(this._createMediaRule(cSSNode4));
                    continue;
                }
                if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode4)) {
                    cSSLayerRule.addRule(this._createSupportsRule(cSSNode4));
                    continue;
                }
                if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode4)) {
                    cSSLayerRule.addRule(this._createKeyframesRule(cSSNode4));
                    continue;
                }
                if (ECSSNodeType.FONTFACERULE.isNode(cSSNode4)) {
                    cSSLayerRule.addRule(this._createFontFaceRule(cSSNode4));
                    continue;
                }
                if (ECSSNodeType.isErrorNode(cSSNode4)) continue;
                this.m_aErrorHandler.onCSSInterpretationError("Unsupported layer-rule child: " + ECSSNodeType.getNodeName(cSSNode4));
            }
        }
        if (this.m_bUseSourceLocation) {
            cSSLayerRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSLayerRule;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.KEYFRAMESRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n == 0) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child but got " + n + "!");
        }
        String string = cSSNode.getText();
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String string2 = cSSNode2.getText();
        CSSKeyframesRule cSSKeyframesRule = new CSSKeyframesRule(string, string2);
        if (this.m_bUseSourceLocation) {
            cSSKeyframesRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        CSSKeyframesBlock cSSKeyframesBlock = null;
        for (int i = 1; i < n; ++i) {
            CommonsArrayList commonsArrayList;
            CSSNode cSSNode3 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(cSSNode3)) {
                commonsArrayList = new CommonsArrayList();
                Iterator<CSSNode> iterator = cSSNode3.iterator();
                while (iterator.hasNext()) {
                    CSSNode cSSNode4 = iterator.next();
                    this._expectNodeType(cSSNode4, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    commonsArrayList.add((Object)cSSNode4.getText());
                }
                cSSKeyframesBlock = new CSSKeyframesBlock((Iterable<String>)commonsArrayList);
                if (this.m_bUseSourceLocation) {
                    cSSKeyframesBlock.setSourceLocation(cSSNode3.getSourceLocation());
                }
                cSSKeyframesRule.addBlock(cSSKeyframesBlock);
                continue;
            }
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode3)) {
                if (cSSKeyframesBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                commonsArrayList = cSSKeyframesBlock;
                this._readStyleDeclarationList(cSSNode3, ((CSSKeyframesBlock)commonsArrayList)::addDeclaration);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode3)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(cSSNode3));
        }
        return cSSKeyframesRule;
    }

    @Nonnull
    private CSSViewportRule _createViewportRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.VIEWPORTRULE);
        String string = cSSNode.getText();
        CSSViewportRule cSSViewportRule = new CSSViewportRule(string);
        if (this.m_bUseSourceLocation) {
            cSSViewportRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2)) {
                this._readStyleDeclarationList(cSSNode2, cSSViewportRule::addDeclaration);
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported viewport rule child: " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSViewportRule;
    }

    @Nonnull
    private CSSNamespaceRule _createNamespaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.NAMESPACERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child and at last 2 children but got " + n + "!");
        }
        String string = null;
        int n2 = 0;
        if (ECSSNodeType.NAMESPACERULEPREFIX.isNode(cSSNode.jjtGetChild(0))) {
            string = cSSNode.jjtGetChild(0).getText();
            ++n2;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
        this._expectNodeType(cSSNode2, ECSSNodeType.NAMESPACERULEURL);
        String string2 = CSSParseHelper.extractStringValue(cSSNode2.getText());
        CSSNamespaceRule cSSNamespaceRule = new CSSNamespaceRule(string, string2);
        if (this.m_bUseSourceLocation) {
            cSSNamespaceRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        return cSSNamespaceRule;
    }

    @Nullable
    private ICSSSupportsConditionMember _createSupportsConditionMemberRecursive(@Nonnull CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.SUPPORTSCONDITIONOPERATOR.isNode(cSSNode)) {
            if (n != 0) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected no children but got " + n + "!");
            }
            return ECSSSupportsConditionOperator.getFromNameCaseInsensitiveOrNull(cSSNode.getText());
        }
        if (ECSSNodeType.SUPPORTSNEGATION.isNode(cSSNode)) {
            ICSSSupportsConditionMember iCSSSupportsConditionMember;
            if (n != 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if ((iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode.jjtGetChild(0))) == null) {
                return null;
            }
            CSSSupportsConditionNegation cSSSupportsConditionNegation = new CSSSupportsConditionNegation(iCSSSupportsConditionMember);
            if (this.m_bUseSourceLocation) {
                cSSSupportsConditionNegation.setSourceLocation(cSSNode.getSourceLocation());
            }
            return cSSSupportsConditionNegation;
        }
        if (ECSSNodeType.SUPPORTSCONDITIONINPARENS.isNode(cSSNode)) {
            CSSNode cSSNode2;
            if (n != 1) {
                this._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2 = cSSNode.jjtGetChild(0))) {
                CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode2);
                if (cSSDeclaration == null) {
                    throw new CSSHandlingException(cSSNode2, "The style declaration in the @supports rule is invalid!");
                }
                CSSSupportsConditionDeclaration cSSSupportsConditionDeclaration = new CSSSupportsConditionDeclaration(cSSDeclaration);
                if (this.m_bUseSourceLocation) {
                    cSSSupportsConditionDeclaration.setSourceLocation(cSSNode2.getSourceLocation());
                }
                return cSSSupportsConditionDeclaration;
            }
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2)) {
                CSSSupportsConditionNested cSSSupportsConditionNested = new CSSSupportsConditionNested();
                Iterator<CSSNode> iterator = cSSNode2.iterator();
                while (iterator.hasNext()) {
                    CSSNode cSSNode3 = iterator.next();
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsConditionNested.addMember(iCSSSupportsConditionMember);
                }
                if (this.m_bUseSourceLocation) {
                    cSSSupportsConditionNested.setSourceLocation(cSSNode2.getSourceLocation());
                }
                return cSSSupportsConditionNested;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supportsConditionInParents child: " + ECSSNodeType.getNodeName(cSSNode2));
            return null;
        }
        if (!ECSSNodeType.isErrorNode(cSSNode)) {
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-condition child: " + ECSSNodeType.getNodeName(cSSNode));
        }
        return null;
    }

    @Nonnull
    private CSSSupportsRule _createSupportsRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SUPPORTSRULE);
        CSSSupportsRule cSSSupportsRule = new CSSSupportsRule();
        if (this.m_bUseSourceLocation) {
            cSSSupportsRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            Object object;
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2)) {
                object = cSSNode2.iterator();
                while (object.hasNext()) {
                    CSSNode cSSNode3 = object.next();
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsRule.addSupportConditionMember(iCSSSupportsConditionMember);
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2)) {
                object = this._createStyleRule(cSSNode2);
                if (object == null) continue;
                cSSSupportsRule.addRule((ICSSTopLevelRule)object);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2)) {
                cSSSupportsRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2)) {
                cSSSupportsRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2)) {
                cSSSupportsRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2)) {
                cSSSupportsRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2)) {
                cSSSupportsRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2)) {
                cSSSupportsRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.LAYERRULE.isNode(cSSNode2)) {
                cSSSupportsRule.addRule(this._createLayerRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-rule child: " + ECSSNodeType.getNodeName(cSSNode2));
        }
        return cSSSupportsRule;
    }

    @Nonnull
    private CSSUnknownRule _createUnknownRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.UNKNOWNRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 2) {
            this._throwUnexpectedChildrenCount(cSSNode, "Expected 2 children but got " + n + "!");
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.UNKNOWNRULEPARAMETERLIST);
        CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
        this._expectNodeType(cSSNode3, ECSSNodeType.UNKNOWNRULEBODY);
        String string = cSSNode.getText();
        CSSUnknownRule cSSUnknownRule = new CSSUnknownRule(string);
        if (this.m_bUseSourceLocation) {
            cSSUnknownRule.setSourceLocation(cSSNode.getSourceLocation());
        }
        cSSUnknownRule.setParameterList(cSSNode2.getText());
        cSSUnknownRule.setBody(cSSNode3.getText());
        return cSSUnknownRule;
    }

    private void _recursiveFillCascadingStyleSheetFromNode(@Nonnull CSSNode cSSNode, @Nonnull CascadingStyleSheet cascadingStyleSheet) {
        this._expectNodeType(cSSNode, ECSSNodeType.ROOT);
        if (this.m_bUseSourceLocation) {
            cascadingStyleSheet.setSourceLocation(cSSNode.getSourceLocation());
        }
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            if (ECSSNodeType.CHARSET.isNode(cSSNode2)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addImportRule(this._createImportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.NAMESPACERULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addNamespaceRule(this._createNamespaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2)) {
                CSSStyleRule cSSStyleRule = this._createStyleRule(cSSNode2);
                if (cSSStyleRule == null) continue;
                cascadingStyleSheet.addRule(cSSStyleRule);
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.LAYERRULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createLayerRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(cSSNode2)) {
                cascadingStyleSheet.addRule(this._createUnknownRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.ROOT.isNode(cSSNode2)) {
                this._recursiveFillCascadingStyleSheetFromNode(cSSNode2, cascadingStyleSheet);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode) + ": " + ECSSNodeType.getNodeName(cSSNode2));
        }
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode cSSNode) {
        CascadingStyleSheet cascadingStyleSheet = new CascadingStyleSheet();
        this._recursiveFillCascadingStyleSheetFromNode(cSSNode, cascadingStyleSheet);
        return cascadingStyleSheet;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode cSSNode) {
        CSSDeclarationList cSSDeclarationList = new CSSDeclarationList();
        if (this.m_bUseSourceLocation) {
            cSSDeclarationList.setSourceLocation(cSSNode.getSourceLocation());
        }
        this._readStyleDeclarationList(cSSNode, cSSDeclarationList::addDeclaration);
        return cSSDeclarationList;
    }
}

