/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.CSSNodeToDomainObject;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.parser.CSSNode;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import jakarta.annotation.Nonnull;

@Immutable
public final class CSSHandler {
    public static final boolean DEFAULT_USE_SOURCE_LOCATION = true;
    private static final CSSHandler INSTANCE = new CSSHandler();

    private CSSHandler() {
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.ROOT.isNode(cSSNode)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a root node!");
        }
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(iCSSInterpretErrorHandler, bl).createCascadingStyleSheetFromNode(cSSNode);
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a style declaration node!");
        }
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(iCSSInterpretErrorHandler, bl).createDeclarationListFromNode(cSSNode);
    }
}

