/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.visit;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberFunction;
import com.helger.css.decl.CSSExpressionMemberMath;
import com.helger.css.decl.CSSExpressionMemberMathProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSLayerRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageMarginBlock;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.decl.visit.ICSSVisitor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSVisitorForUrl
implements ICSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private final NonBlockingStack<ICSSTopLevelRule> m_aTopLevelRule = new NonBlockingStack();

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        this.m_aVisitor = (ICSSUrlVisitor)ValueEnforcer.notNull((Object)iCSSUrlVisitor, (String)"Visitor");
    }

    @Nonnull
    public ICSSUrlVisitor getVisitor() {
        return this.m_aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule cSSImportRule) {
        this.m_aVisitor.onImport(cSSImportRule);
    }

    @Override
    public void onNamespace(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
    }

    private void _recursiveCheckMathMember(@Nullable ICSSTopLevelRule iCSSTopLevelRule, @Nonnull CSSDeclaration cSSDeclaration, @Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        if (iCSSExpressionMathMember instanceof CSSExpressionMemberFunction) {
            CSSExpressionMemberFunction cSSExpressionMemberFunction = (CSSExpressionMemberFunction)iCSSExpressionMathMember;
            this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberFunction.getExpression());
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMath) {
            CSSExpressionMemberMath cSSExpressionMemberMath = (CSSExpressionMemberMath)iCSSExpressionMathMember;
            for (ICSSExpressionMathMember iCSSExpressionMathMember2 : cSSExpressionMemberMath.getAllMembers()) {
                this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember2);
            }
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMathProduct) {
            CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = (CSSExpressionMemberMathProduct)iCSSExpressionMathMember;
            for (ICSSExpressionMathMember iCSSExpressionMathMember3 : cSSExpressionMemberMathProduct.getAllMembers()) {
                this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember3);
            }
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMathUnitProduct) {
            CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = (CSSExpressionMemberMathUnitProduct)iCSSExpressionMathMember;
            this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberMathUnitProduct.getProduct());
        }
    }

    private void _recursiveCheckExpression(@Nullable ICSSTopLevelRule iCSSTopLevelRule, @Nonnull CSSDeclaration cSSDeclaration, @Nullable CSSExpression cSSExpression) {
        if (cSSExpression != null) {
            for (ICSSExpressionMember iCSSExpressionMember : cSSExpression.getAllMembers()) {
                ICSSExpressionMember iCSSExpressionMember2;
                if (iCSSExpressionMember instanceof CSSExpressionMemberFunction) {
                    iCSSExpressionMember2 = (CSSExpressionMemberFunction)iCSSExpressionMember;
                    this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, ((CSSExpressionMemberFunction)iCSSExpressionMember2).getExpression());
                    continue;
                }
                if (iCSSExpressionMember instanceof CSSExpressionMemberMath) {
                    iCSSExpressionMember2 = (CSSExpressionMemberMath)iCSSExpressionMember;
                    for (ICSSExpressionMathMember iCSSExpressionMathMember : ((CSSExpressionMemberMath)iCSSExpressionMember2).getAllMembers()) {
                        this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember);
                    }
                    continue;
                }
                if (!(iCSSExpressionMember instanceof CSSExpressionMemberTermURI)) continue;
                iCSSExpressionMember2 = (CSSExpressionMemberTermURI)iCSSExpressionMember;
                this.m_aVisitor.onUrlDeclaration(iCSSTopLevelRule, cSSDeclaration, (CSSExpressionMemberTermURI)iCSSExpressionMember2);
            }
        }
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        ICSSTopLevelRule iCSSTopLevelRule = this.m_aTopLevelRule.isEmpty() ? null : (ICSSTopLevelRule)this.m_aTopLevelRule.peek();
        this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, cSSDeclaration.getExpression());
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.push((Object)cSSStyleRule);
    }

    @Override
    public void onStyleRuleSelector(@Nonnull CSSSelector cSSSelector) {
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.push((Object)cSSPageRule);
    }

    @Override
    public void onBeginPageMarginBlock(@Nonnull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageMarginBlock(@Nonnull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.push((Object)cSSFontFaceRule);
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.push((Object)cSSMediaRule);
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.push((Object)cSSKeyframesRule);
    }

    @Override
    public void onBeginKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.push((Object)cSSViewportRule);
    }

    @Override
    public void onEndViewportRule(@Nonnull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.push((Object)cSSSupportsRule);
    }

    @Override
    public void onEndSupportsRule(@Nonnull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginLayerRule(@Nonnull CSSLayerRule cSSLayerRule) {
        this.m_aTopLevelRule.push((Object)cSSLayerRule);
    }

    @Override
    public void onEndLayerRule(@Nonnull CSSLayerRule cSSLayerRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onUnknownRule(@Nonnull CSSUnknownRule cSSUnknownRule) {
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

