/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.AbstractHasTopLevelRules;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaRule
extends AbstractHasTopLevelRules
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final ICommonsList<CSSMediaQuery> m_aMediaQueries = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMediaQueries() {
        return this.m_aMediaQueries.isNotEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnull @Nonempty CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add((Object)cSSMediaQuery);
        return this;
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnegative int n, @Nonnull @Nonempty CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        if (n >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add((Object)cSSMediaQuery);
        } else {
            this.m_aMediaQueries.add(n, (Object)cSSMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery cSSMediaQuery) {
        return this.m_aMediaQueries.removeObject((Object)cSSMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int n) {
        return this.m_aMediaQueries.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        return this.m_aMediaQueries.removeAll();
    }

    @Nullable
    public CSSMediaQuery getMediaQueryAtIndex(@Nonnegative int n) {
        return (CSSMediaQuery)this.m_aMediaQueries.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaQuery> getAllMediaQueries() {
        return (ICommonsList)this.m_aMediaQueries.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteMediaRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aRules.size();
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("@media ");
        boolean bl2 = true;
        for (ICSSWriteable iCSSWriteable : this.m_aMediaQueries) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(((CSSMediaQuery)iCSSWriteable).getAsCSSString(iCSSWriterSettings, n));
        }
        if (n2 == 0) {
            stringBuilder.append((String)(bl ? "{}" : " {}" + iCSSWriterSettings.getNewLineString()));
        } else {
            stringBuilder.append((String)(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString()));
            bl2 = true;
            for (ICSSWriteable iCSSWriteable : this.m_aRules) {
                String string = iCSSWriteable.getAsCSSString(iCSSWriterSettings, n + 1);
                if (!StringHelper.hasText((String)string)) continue;
                if (bl2) {
                    bl2 = false;
                } else if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getNewLineString());
                }
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
                }
                stringBuilder.append(string);
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getNewLineString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)object;
        return this.m_aMediaQueries.equals(cSSMediaRule.m_aMediaQueries) && this.m_aRules.equals((Object)cSSMediaRule.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMediaQueries).append((Iterable)this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mediaQueries", this.m_aMediaQueries).append("styleRules", (Object)this.m_aRules).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

