/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSKeyframesBlock
implements IHasCSSDeclarations<CSSKeyframesBlock>,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aKeyframesSelectors;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public CSSKeyframesBlock(String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList((Object[])stringArray);
    }

    public CSSKeyframesBlock(@Nonnull @Nonempty Iterable<String> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllKeyframesSelectors() {
        return (ICommonsList)this.m_aKeyframesSelectors.getClone();
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyNameCaseInsensitive(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyNameCaseInsensitive(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyNameCaseInsensitive(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyNameCaseInsensitive(string);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.m_aKeyframesSelectors) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSKeyframesBlock cSSKeyframesBlock = (CSSKeyframesBlock)object;
        return this.m_aKeyframesSelectors.equals(cSSKeyframesBlock.m_aKeyframesSelectors) && this.m_aDeclarations.equals(cSSKeyframesBlock.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aKeyframesSelectors).append((Iterable)((Object)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("KeyframesSelectors", this.m_aKeyframesSelectors).append("Declarations", (Object)this.m_aDeclarations).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

