/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.CSSNodeToDomainObject;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.parser.CSSNode;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSHandler {
    private static final CSSHandler s_aInstance = new CSSHandler();

    private CSSHandler() {
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.ROOT.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a root node!");
        }
        return new CSSNodeToDomainObject(eCSSVersion).createCascadingStyleSheetFromNode(cSSNode);
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a style declaration node!");
        }
        return new CSSNodeToDomainObject(eCSSVersion).createDeclarationListFromNode(cSSNode);
    }
}

