/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
extends CSSWritableList<CSSDeclaration>
implements IHasCSSDeclarations<CSSDeclarationList> {
    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.add(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression, boolean bl) {
        return this.addDeclaration(new CSSDeclaration(string, cSSExpression, bl));
    }

    @Override
    @Nonnull
    public CSSDeclarationList addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.add(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.remove(cSSDeclaration);
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int n) {
        return this.remove(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.removeAll();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<CSSDeclaration> getAllDeclarations() {
        return this.getAll();
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return (CSSDeclaration)this.getAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSDeclarationList setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.set(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.getCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.directGetAll()) {
                if (!cSSDeclaration.getProperty().equals(string)) continue;
                return cSSDeclaration;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyNameCaseInsensitive(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.directGetAll()) {
                if (!cSSDeclaration.getProperty().equalsIgnoreCase(string)) continue;
                return cSSDeclaration;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        ArrayList<CSSDeclaration> arrayList = new ArrayList<CSSDeclaration>();
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.directGetAll()) {
                if (!cSSDeclaration.getProperty().equals(string)) continue;
                arrayList.add(cSSDeclaration);
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyNameCaseInsensitive(@Nullable String string) {
        ArrayList<CSSDeclaration> arrayList = new ArrayList<CSSDeclaration>();
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.directGetAll()) {
                if (!cSSDeclaration.getProperty().equalsIgnoreCase(string)) continue;
                arrayList.add(cSSDeclaration);
            }
        }
        return arrayList;
    }
}

