/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.css.parser.CSSParseHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSURLHelper {
    public static final boolean DEFAULT_QUOTE_URLS = false;
    private static final CSSURLHelper s_aInstance = new CSSURLHelper();

    private CSSURLHelper() {
    }

    public static boolean isURLValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasNoText((String)string2)) {
            return false;
        }
        if (string2.equals("none")) {
            return true;
        }
        return string2.length() > 5 && string2.startsWith("url(") && string2.endsWith(")");
    }

    @Nullable
    public static String getURLValue(@Nullable String string) {
        if (CSSURLHelper.isURLValue(string)) {
            return CSSParseHelper.trimUrl(string);
        }
        return null;
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull ISimpleURL iSimpleURL, boolean bl) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        return CSSURLHelper.getAsCSSURL(iSimpleURL.getAsString(), bl);
    }

    public static boolean isValidCSSURLChar(char c) {
        return c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c >= '*' && c <= '[' || c >= ']' && c <= '~' || c >= '\u0080' && c <= '\uffff';
    }

    public static boolean isCSSURLRequiringQuotes(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"URL");
        for (char c : string.toCharArray()) {
            if (CSSURLHelper.isValidCSSURLChar(c)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    @Nonempty
    public static String getEscapedCSSURL(@Nonnull String string, char c) {
        ValueEnforcer.notNull((Object)string, (String)"URL");
        if (string.indexOf(c) < 0 && string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c2 : string.toCharArray()) {
            if (c2 == c || c2 == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull String string, boolean bl) {
        boolean bl2;
        ValueEnforcer.notNull((Object)string, (String)"URL");
        StringBuilder stringBuilder = new StringBuilder("url(");
        boolean bl3 = bl2 = bl || CSSURLHelper.isCSSURLRequiringQuotes(string);
        if (bl2) {
            int n = string.indexOf(39);
            int n2 = string.indexOf(34);
            char c = n >= 0 && n2 < 0 ? (char)'\"' : '\'';
            stringBuilder.append(c).append(CSSURLHelper.getEscapedCSSURL(string, c)).append(c);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.append(")").toString();
    }
}

