/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ReadOnlyToken;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSParseError {
    private final ReadOnlyToken m_aLastValidToken;
    private final String m_sExpectedTokens;
    private final ReadOnlyToken m_aFirstSkippedToken;
    private final ReadOnlyToken m_aLastSkippedToken;
    private final String m_sErrorMessage;

    public CSSParseError(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ErrorMsg");
        this.m_aLastValidToken = null;
        this.m_sExpectedTokens = null;
        this.m_aFirstSkippedToken = null;
        this.m_aLastSkippedToken = null;
        this.m_sErrorMessage = string;
    }

    public CSSParseError(@Nonnull Token token, @Nonnull int[][] nArray, @Nonnull String[] stringArray, @Nullable Token token2) {
        ValueEnforcer.notNull((Object)token, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)nArray, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)stringArray, (String)"TokenImageVal");
        this.m_aLastValidToken = new ReadOnlyToken(token);
        StringBuilder stringBuilder = new StringBuilder();
        for (int[] nArray2 : nArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            for (int n : nArray2) {
                stringBuilder.append(' ').append(stringArray[n]);
            }
        }
        this.m_sExpectedTokens = stringBuilder.toString();
        this.m_aFirstSkippedToken = new ReadOnlyToken(token.next);
        this.m_aLastSkippedToken = token2 == null ? null : new ReadOnlyToken(token2);
        this.m_sErrorMessage = LoggingCSSParseErrorHandler.createLoggingStringParseError(token, nArray, stringArray, token2);
    }

    @Nullable
    public ReadOnlyToken getLastValidToken() {
        return this.m_aLastValidToken;
    }

    @Nullable
    public String getExpectedTokens() {
        return this.m_sExpectedTokens;
    }

    @Nullable
    public ReadOnlyToken getFirstSkippedToken() {
        return this.m_aFirstSkippedToken;
    }

    @Nullable
    public ReadOnlyToken getLastSkippedToken() {
        return this.m_aLastSkippedToken;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("lastValidToken", (Object)this.m_aLastValidToken).appendIfNotNull("expectedTokens", (Object)this.m_sExpectedTokens).appendIfNotNull("firstSkippedToken", (Object)this.m_aFirstSkippedToken).appendIfNotNull("lastSkippedToken", (Object)this.m_aLastSkippedToken).append("errorMessage", (Object)this.m_sErrorMessage).toString();
    }

    @Nonnull
    public static CSSParseError createUnexpectedRule(@Nonnull Token token, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(token, string, string2));
    }
}

