/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.IHasReader;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingPushbackInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.streamprovider.StringInputStreamProvider;
import com.helger.commons.io.streamprovider.StringReaderProvider;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS21;
import com.helger.css.parser.ParserCSS21TokenManager;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.parser.ParserCSSCharsetDetector;
import com.helger.css.parser.ParserCSSCharsetDetectorTokenManager;
import com.helger.css.parser.TokenMgrError;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSSReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReader.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new ThrowingCSSParseErrorHandler();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    private static final CSSReader s_aInstance = new CSSReader();

    private CSSReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseErrorHandler iCSSParseErrorHandler = s_aDefaultParseErrorHandler;
            return iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseExceptionCallback iCSSParseExceptionCallback = s_aDefaultParseExceptionHandler;
            return iCSSParseExceptionCallback;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iCSSParseExceptionCallback, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionCallback;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    private static CSSNode _readStyleSheet(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback, boolean bl) {
        try {
            switch (eCSSVersion) {
                case CSS21: {
                    ParserCSS21TokenManager parserCSS21TokenManager = new ParserCSS21TokenManager(charStream);
                    ParserCSS21 parserCSS21 = new ParserCSS21(parserCSS21TokenManager);
                    parserCSS21.setCustomErrorHandler(iCSSParseErrorHandler);
                    parserCSS21.setBrowserCompliantMode(bl);
                    return parserCSS21.styleSheet();
                }
                case CSS30: {
                    ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                    ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                    parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
                    parserCSS30.setBrowserCompliantMode(bl);
                    return parserCSS30.styleSheet();
                }
            }
            throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eCSSVersion));
        }
        catch (ParseException parseException) {
            iCSSParseExceptionCallback.onException(parseException);
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            iCSSParseExceptionCallback.onException(new ParseException(tokenMgrError.getMessage()));
            return null;
        }
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(file), charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReader.isValidCSS(reader, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        return CSSReader.isValidCSS(StreamHelper.createReader((InputStream)inputStream, (Charset)charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)string, (String)"CSS");
        return CSSReader.isValidCSS((Reader)new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, CSSReader.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback(), false);
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamHelper.close((Closeable)reader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringStream(@Nonnull String string, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream((IHasInputStream)new StringInputStreamProvider(string, cSSReaderSettings.getFallbackCharset()), cSSReaderSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringReader(@Nonnull String string, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromReader((IHasReader)new StringReaderProvider(string), cSSReaderSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream((IHasInputStream)new FileSystemResource(file), cSSReaderSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    private static InputStreamAndCharset _getInputStreamWithoutBOM(@Nonnull IHasInputStream iHasInputStream) {
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        int n = EUnicodeBOM.getMaximumByteCount();
        NonBlockingPushbackInputStream nonBlockingPushbackInputStream = new NonBlockingPushbackInputStream(inputStream, n);
        try {
            byte[] byArray = new byte[n];
            int n2 = nonBlockingPushbackInputStream.read(byArray);
            Charset charset = null;
            if (n2 > 0) {
                EUnicodeBOM eUnicodeBOM = EUnicodeBOM.getFromBytesOrNull((byte[])ArrayHelper.getCopy((byte[])byArray, (int)0, (int)n2));
                if (eUnicodeBOM == null) {
                    nonBlockingPushbackInputStream.unread(byArray, 0, n2);
                } else {
                    int n3 = eUnicodeBOM.getByteCount();
                    if (n3 < n2) {
                        nonBlockingPushbackInputStream.unread(byArray, n3, n2 - n3);
                    }
                    charset = eUnicodeBOM.getCharset();
                }
            }
            return new InputStreamAndCharset((InputStream)nonBlockingPushbackInputStream, charset);
        }
        catch (IOException iOException) {
            s_aLogger.error("Failed to determine BOM", (Throwable)iOException);
            return null;
        }
    }

    @Nullable
    public static Charset getCharsetDeclaredInCSS(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStreamAndCharset inputStreamAndCharset = CSSReader._getInputStreamWithoutBOM(iHasInputStream);
        if (inputStreamAndCharset == null || !inputStreamAndCharset.hasInputStream()) {
            return null;
        }
        InputStream inputStream = inputStreamAndCharset.getInputStream();
        Charset charset = inputStreamAndCharset.getCharset();
        Charset charset2 = charset;
        if (charset2 == null) {
            charset2 = CCharset.CHARSET_ISO_8859_1_OBJ;
        }
        InputStreamReader inputStreamReader = StreamHelper.createReader((InputStream)inputStream, (Charset)charset2);
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            ParserCSSCharsetDetectorTokenManager parserCSSCharsetDetectorTokenManager = new ParserCSSCharsetDetectorTokenManager(cSSCharStream);
            ParserCSSCharsetDetector parserCSSCharsetDetector = new ParserCSSCharsetDetector(parserCSSCharsetDetectorTokenManager);
            String string = parserCSSCharsetDetector.styleSheetCharset().getText();
            if (string == null) {
                Charset charset3 = inputStreamAndCharset.getCharset();
                return charset3;
            }
            String string2 = CSSParseHelper.extractStringValue(string);
            Charset charset4 = CharsetManager.getCharsetFromName((String)string2);
            if (charset != null && !charset.equals(charset4)) {
                s_aLogger.warn("The charset found in the CSS data (" + charset4.name() + ") differs from the charset determined by the BOM (" + charset.name() + ") -> Using the read charset");
            }
            Charset charset5 = charset4;
            return charset5;
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("Failed to parse CSS charset definition", parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new IllegalStateException("Failed to parse CSS charset definition", tokenMgrError);
        }
        finally {
            StreamHelper.close((Closeable)inputStreamReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromStream(iHasInputStream, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull CSSReaderSettings cSSReaderSettings) {
        Charset charset;
        Charset charset2;
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        try {
            charset2 = CSSReader.getCharsetDeclaredInCSS(iHasInputStream);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        if (charset2 != null) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Reading CSS definition again with explicit charset '" + charset2.name() + "'");
            }
            charset = charset2;
        } else {
            charset = cSSReaderSettings.getFallbackCharset();
        }
        InputStreamAndCharset inputStreamAndCharset = CSSReader._getInputStreamWithoutBOM(iHasInputStream);
        if (inputStreamAndCharset == null || !inputStreamAndCharset.hasInputStream()) {
            return null;
        }
        InputStream inputStream = inputStreamAndCharset.getInputStream();
        InputStreamReader inputStreamReader = StreamHelper.createReader((InputStream)inputStream, (Charset)charset);
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            boolean bl;
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionCallback, bl = cSSReaderSettings.isBrowserCompliantMode())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close((Closeable)inputStreamReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IHasReader iHasReader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReader.readFromReader(iHasReader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IHasReader iHasReader, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)iHasReader, (String)"ReaderProvider");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        Reader reader = iHasReader.getReader();
        if (reader == null) {
            return null;
        }
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            boolean bl;
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionCallback, bl = cSSReaderSettings.isBrowserCompliantMode())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close((Closeable)reader);
        }
    }

    private static final class InputStreamAndCharset
    implements IHasInputStream {
        private final InputStream m_aIS;
        private final Charset m_aCharset;

        public InputStreamAndCharset(@Nullable InputStream inputStream, @Nullable Charset charset) {
            this.m_aIS = inputStream;
            this.m_aCharset = charset;
        }

        @Nullable
        public InputStream getInputStream() {
            return this.m_aIS;
        }

        public boolean hasInputStream() {
            return this.m_aIS != null;
        }

        @Nullable
        public Charset getCharset() {
            return this.m_aCharset;
        }
    }
}

