/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.handler.ICSSParseExceptionHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSReaderSettings
implements ICloneable<CSSReaderSettings> {
    public static final ECSSVersion DEFAULT_VERSION = ECSSVersion.CSS30;
    public static final Charset DEFAULT_CHARSET = CCharset.CHARSET_ISO_8859_1_OBJ;
    private ECSSVersion m_eCSSVersion = DEFAULT_VERSION;
    private Charset m_aFallbackCharset = DEFAULT_CHARSET;
    private ICSSParseErrorHandler m_aCustomErrorHandler;
    private ICSSParseExceptionHandler m_aCustomExceptionHandler;

    public CSSReaderSettings() {
    }

    public CSSReaderSettings(@Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Other");
        this.m_eCSSVersion = cSSReaderSettings.m_eCSSVersion;
        this.m_aFallbackCharset = cSSReaderSettings.m_aFallbackCharset;
        this.m_aCustomErrorHandler = cSSReaderSettings.m_aCustomErrorHandler;
        this.m_aCustomExceptionHandler = cSSReaderSettings.m_aCustomExceptionHandler;
    }

    @Nonnull
    public ECSSVersion getCSSVersion() {
        return this.m_eCSSVersion;
    }

    @Nonnull
    public CSSReaderSettings setCSSVersion(@Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"CSSVersion");
        this.m_eCSSVersion = eCSSVersion;
        return this;
    }

    @Nonnull
    public Charset getFallbackCharset() {
        return this.m_aFallbackCharset;
    }

    @Nonnull
    public String getFallbackCharsetName() {
        return this.m_aFallbackCharset.name();
    }

    @Nonnull
    @Deprecated
    public CSSReaderSettings setFallbackCharset(@Nonnull @Nonempty String string) {
        Charset charset = CharsetManager.getCharsetFromName((String)string);
        return this.setFallbackCharset(charset);
    }

    @Nonnull
    public CSSReaderSettings setFallbackCharset(@Nonnull @Nonempty Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        this.m_aFallbackCharset = charset;
        return this;
    }

    @Nullable
    public ICSSParseErrorHandler getCustomErrorHandler() {
        return this.m_aCustomErrorHandler;
    }

    @Nonnull
    public CSSReaderSettings setCustomErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        this.m_aCustomErrorHandler = iCSSParseErrorHandler;
        return this;
    }

    @Nullable
    public ICSSParseExceptionHandler getCustomExceptionHandler() {
        return this.m_aCustomExceptionHandler;
    }

    @Nonnull
    public CSSReaderSettings setCustomExceptionHandler(@Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        this.m_aCustomExceptionHandler = iCSSParseExceptionHandler;
        return this;
    }

    @Nonnull
    public CSSReaderSettings getClone() {
        return new CSSReaderSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("CSSVersion", (Enum)this.m_eCSSVersion).append("FallbackCharset", (Object)this.m_aFallbackCharset).append("CustomErrorHandler", (Object)this.m_aCustomErrorHandler).append("CustomExceptionHandler", (Object)this.m_aCustomExceptionHandler).toString();
    }
}

