/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.io.IInputStreamProvider;
import com.helger.commons.io.IReadableResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.streams.NonBlockingStringReader;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionHandler;
import com.helger.css.handler.ICSSParseExceptionHandler;
import com.helger.css.handler.LoggingCSSParseExceptionHandler;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS21;
import com.helger.css.parser.ParserCSS21TokenManager;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReaderDeclarationList {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReaderDeclarationList.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = ThrowingCSSParseErrorHandler.getInstance();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionHandler s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionHandler();
    private static final CSSReaderDeclarationList s_aInstance = new CSSReaderDeclarationList();

    private CSSReaderDeclarationList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseErrorHandler iCSSParseErrorHandler = s_aDefaultParseErrorHandler;
            return iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ICSSParseExceptionHandler getDefaultParseExceptionHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseExceptionHandler iCSSParseExceptionHandler = s_aDefaultParseExceptionHandler;
            return iCSSParseExceptionHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        ValueEnforcer.notNull((Object)iCSSParseExceptionHandler, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nonnull ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        switch (eCSSVersion) {
            case CSS21: {
                ParserCSS21TokenManager parserCSS21TokenManager = new ParserCSS21TokenManager(charStream);
                ParserCSS21 parserCSS21 = new ParserCSS21(parserCSS21TokenManager);
                parserCSS21.setCustomErrorHandler(iCSSParseErrorHandler);
                try {
                    return parserCSS21.styleDeclarationList();
                }
                catch (ParseException parseException) {
                    iCSSParseExceptionHandler.onException(parseException);
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
                try {
                    return parserCSS30.styleDeclarationList();
                }
                catch (ParseException parseException) {
                    iCSSParseExceptionHandler.onException(parseException);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eCSSVersion));
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(file), string, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(file), charset, eCSSVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        Charset charset = CharsetManager.getCharsetFromName((String)string);
        return CSSReaderDeclarationList.isValidCSS(iReadableResource, charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(reader, eCSSVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull @Nonempty String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (String)string), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (Charset)charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)string, (String)"CSS");
        return CSSReaderDeclarationList.isValidCSS((Reader)new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, eCSSVersion, CSSReaderDeclarationList.getDefaultParseErrorHandler(), DoNothingCSSParseExceptionHandler.getInstance());
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)reader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, string, eCSSVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, charset, eCSSVersion, null, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, string, eCSSVersion, iCSSParseErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, charset, eCSSVersion, iCSSParseErrorHandler, null);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, string, eCSSVersion, null, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, charset, eCSSVersion, null, iCSSParseExceptionHandler);
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        Charset charset = CharsetManager.getCharsetFromName((String)string);
        return CSSReaderDeclarationList.readFromStream(iInputStreamProvider, charset, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        ValueEnforcer.notNull((Object)iInputStreamProvider, (String)"InputStreamProvider");
        InputStream inputStream = iInputStreamProvider.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (String)string), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (String)string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (String)string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    @Deprecated
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (String)string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        return CSSReaderDeclarationList.readFromReader((Reader)StreamUtils.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            CSSNode cSSNode;
            ICSSParseExceptionHandler iCSSParseExceptionHandler;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReaderDeclarationList.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionHandler = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionHandler = CSSReaderDeclarationList.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionHandler)) == null) {
                CSSDeclarationList cSSDeclarationList = null;
                return cSSDeclarationList;
            }
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(eCSSVersion, cSSNode);
            return cSSDeclarationList;
        }
        finally {
            StreamUtils.close((Closeable)reader);
        }
    }
}

