/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.collections.pair.ReadonlyPair;
import com.helger.commons.io.IInputStreamProvider;
import com.helger.commons.io.IReadableResource;
import com.helger.commons.io.IReaderProvider;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.streamprovider.StringInputStreamProvider;
import com.helger.commons.io.streamprovider.StringReaderProvider;
import com.helger.commons.io.streams.NonBlockingStringReader;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionHandler;
import com.helger.css.handler.ICSSParseExceptionHandler;
import com.helger.css.handler.LoggingCSSParseExceptionHandler;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParseUtils;
import com.helger.css.parser.ParserCSS21;
import com.helger.css.parser.ParserCSS21TokenManager;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.parser.ParserCSSCharsetDetector;
import com.helger.css.parser.ParserCSSCharsetDetectorTokenManager;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSSReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReader.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = ThrowingCSSParseErrorHandler.getInstance();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionHandler s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionHandler();
    private static final CSSReader s_aInstance = new CSSReader();

    private CSSReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseErrorHandler iCSSParseErrorHandler = s_aDefaultParseErrorHandler;
            return iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ICSSParseExceptionHandler getDefaultParseExceptionHandler() {
        s_aRWLock.readLock().lock();
        try {
            ICSSParseExceptionHandler iCSSParseExceptionHandler = s_aDefaultParseExceptionHandler;
            return iCSSParseExceptionHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        ValueEnforcer.notNull((Object)iCSSParseExceptionHandler, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    private static CSSNode _readStyleSheet(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nonnull ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        switch (eCSSVersion) {
            case CSS21: {
                ParserCSS21TokenManager parserCSS21TokenManager = new ParserCSS21TokenManager(charStream);
                ParserCSS21 parserCSS21 = new ParserCSS21(parserCSS21TokenManager);
                parserCSS21.setCustomErrorHandler(iCSSParseErrorHandler);
                try {
                    return parserCSS21.styleSheet();
                }
                catch (ParseException parseException) {
                    iCSSParseExceptionHandler.onException(parseException);
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
                try {
                    return parserCSS30.styleSheet();
                }
                catch (ParseException parseException) {
                    iCSSParseExceptionHandler.onException(parseException);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eCSSVersion));
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(file), string, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(file), charset, eCSSVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull @Nonempty String string, @Nonnull ECSSVersion eCSSVersion) {
        Charset charset = CharsetManager.getCharsetFromName((String)string);
        return CSSReader.isValidCSS(iReadableResource, charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReader.isValidCSS(reader, eCSSVersion);
    }

    @Deprecated
    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull @Nonempty String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Charset");
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (String)string), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (Charset)charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)string, (String)"CSS");
        return CSSReader.isValidCSS((Reader)new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, CSSReader.getDefaultParseErrorHandler(), DoNothingCSSParseExceptionHandler.getInstance());
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)reader);
        }
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull String string2, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(string2).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull String string2, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(string2).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull String string2, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(string2).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull String string2, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(string2).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStringStream(string, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringStream(@Nonnull String string, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream((IInputStreamProvider)new StringInputStreamProvider(string, cSSReaderSettings.getFallbackCharset()), cSSReaderSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStringReader(string, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringReader(@Nonnull String string, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromReader((IReaderProvider)new StringReaderProvider(string), cSSReaderSettings);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromFile(file, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(file), cSSReaderSettings);
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    @Deprecated
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(string).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    private static ReadonlyPair<InputStream, Charset> _getInputStreamWithoutBOM(@Nonnull IInputStreamProvider iInputStreamProvider) {
        InputStream inputStream = iInputStreamProvider.getInputStream();
        if (inputStream == null) {
            return null;
        }
        int n = EUnicodeBOM.getMaximumByteCount();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, n);
        try {
            byte[] byArray = new byte[n];
            int n2 = pushbackInputStream.read(byArray);
            Charset charset = null;
            if (n2 > 0) {
                EUnicodeBOM eUnicodeBOM = EUnicodeBOM.getFromBytesOrNull((byte[])ArrayHelper.getCopy((byte[])byArray, (int)0, (int)n2));
                if (eUnicodeBOM == null) {
                    pushbackInputStream.unread(byArray, 0, n2);
                } else {
                    int n3 = eUnicodeBOM.getByteCount();
                    if (n3 < n2) {
                        pushbackInputStream.unread(byArray, n3, n2 - n3);
                    }
                    charset = eUnicodeBOM.getCharset();
                }
            }
            return new ReadonlyPair((Object)pushbackInputStream, charset);
        }
        catch (IOException iOException) {
            s_aLogger.error("Failed to determine BOM", (Throwable)iOException);
            return null;
        }
    }

    @Nullable
    public static Charset getCharsetDeclaredInCSS(@Nonnull IInputStreamProvider iInputStreamProvider) {
        ValueEnforcer.notNull((Object)iInputStreamProvider, (String)"InputStreamProvider");
        ReadonlyPair<InputStream, Charset> readonlyPair = CSSReader._getInputStreamWithoutBOM(iInputStreamProvider);
        if (readonlyPair == null || readonlyPair.getFirst() == null) {
            return null;
        }
        InputStream inputStream = (InputStream)readonlyPair.getFirst();
        Charset charset = (Charset)readonlyPair.getSecond();
        Charset charset2 = charset;
        if (charset2 == null) {
            charset2 = CCharset.CHARSET_ISO_8859_1_OBJ;
        }
        InputStreamReader inputStreamReader = StreamUtils.createReader((InputStream)inputStream, (Charset)charset2);
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            ParserCSSCharsetDetectorTokenManager parserCSSCharsetDetectorTokenManager = new ParserCSSCharsetDetectorTokenManager(cSSCharStream);
            ParserCSSCharsetDetector parserCSSCharsetDetector = new ParserCSSCharsetDetector(parserCSSCharsetDetectorTokenManager);
            String string = parserCSSCharsetDetector.styleSheetCharset().getText();
            if (string == null) {
                Charset charset3 = (Charset)readonlyPair.getSecond();
                return charset3;
            }
            String string2 = ParseUtils.extractStringValue(string);
            Charset charset4 = CharsetManager.getCharsetFromName((String)string2);
            if (charset != null && !charset.equals(charset4)) {
                s_aLogger.warn("The charset found in the CSS data (" + charset4.name() + ") differs from the charset determined by the BOM (" + charset.name() + ")!");
            }
            Charset charset5 = charset4;
            return charset5;
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("Failed to parse CSS charset definition", parseException);
        }
        finally {
            StreamUtils.close((Closeable)inputStreamReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream(iInputStreamProvider, new CSSReaderSettings().setFallbackCharset(charset).setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull CSSReaderSettings cSSReaderSettings) {
        Charset charset;
        ValueEnforcer.notNull((Object)iInputStreamProvider, (String)"InputStreamProvider");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        Charset charset2 = CSSReader.getCharsetDeclaredInCSS(iInputStreamProvider);
        if (charset2 != null) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Reading CSS definition again with explicit charset '" + charset2.name() + "'");
            }
            charset = charset2;
        } else {
            charset = cSSReaderSettings.getFallbackCharset();
        }
        ReadonlyPair<InputStream, Charset> readonlyPair = CSSReader._getInputStreamWithoutBOM(iInputStreamProvider);
        if (readonlyPair == null || readonlyPair.getFirst() == null) {
            return null;
        }
        InputStream inputStream = (InputStream)readonlyPair.getFirst();
        InputStreamReader inputStreamReader = StreamUtils.createReader((InputStream)inputStream, (Charset)charset);
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            CSSNode cSSNode;
            ICSSParseExceptionHandler iCSSParseExceptionHandler;
            CSSCharStream cSSCharStream = new CSSCharStream(inputStreamReader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionHandler = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionHandler = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionHandler)) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamUtils.close((Closeable)inputStreamReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IReaderProvider iReaderProvider, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromReader(iReaderProvider, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IReaderProvider iReaderProvider, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)iReaderProvider, (String)"ReaderProvider");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        Reader reader = iReaderProvider.getReader();
        if (reader == null) {
            return null;
        }
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            CSSNode cSSNode;
            ICSSParseExceptionHandler iCSSParseExceptionHandler;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionHandler = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionHandler = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReader._readStyleSheet(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionHandler)) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamUtils.close((Closeable)reader);
        }
    }
}

