/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSupportsConditionMember;
import com.helger.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware,
ICSSVersionAware {
    private final List<ICSSSupportsConditionMember> m_aConditionMembers = new ArrayList<ICSSSupportsConditionMember>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSupportConditionMembers() {
        return !this.m_aConditionMembers.isEmpty();
    }

    @Nonnegative
    public int getSupportsConditionMemberCount() {
        return this.m_aConditionMembers.size();
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.notNull((Object)iCSSSupportsConditionMember, (String)"SupportsConditionMember");
        this.m_aConditionMembers.add(iCSSSupportsConditionMember);
        return this;
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnegative int n, @Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSSupportsConditionMember, (String)"SupportsConditionMember");
        if (n >= this.getSupportsConditionMemberCount()) {
            this.m_aConditionMembers.add(iCSSSupportsConditionMember);
        } else {
            this.m_aConditionMembers.add(n, iCSSSupportsConditionMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        return EChange.valueOf((boolean)this.m_aConditionMembers.remove(iCSSSupportsConditionMember));
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aConditionMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aConditionMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllSupportsConditionMembers() {
        if (this.m_aConditionMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aConditionMembers.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSSupportsConditionMember getSupportsConditionMemberAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aConditionMembers.size()) {
            return null;
        }
        return this.m_aConditionMembers.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSupportsConditionMember> getAllSupportConditionMembers() {
        return ContainerHelper.newList(this.m_aConditionMembers);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nonnull
    public CSSSupportsRule addRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        this.m_aRules.add(iCSSTopLevelRule);
        return this;
    }

    @Nonnull
    public CSSSupportsRule addRule(@Nonnegative int n, @Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        if (n >= this.getRuleCount()) {
            this.m_aRules.add(iCSSTopLevelRule);
        } else {
            this.m_aRules.add(n, iCSSTopLevelRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(iCSSTopLevelRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSTopLevelRule getRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return null;
        }
        return this.m_aRules.get(n);
    }

    @Nonnull
    public EChange removeAllDeclarations() {
        if (this.m_aRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (!iCSSWriterSettings.isWriteSupportsRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aRules.size();
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("@supports ");
        boolean bl2 = true;
        for (ICSSSupportsConditionMember iCSSWriteable : this.m_aConditionMembers) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(iCSSWriteable.getAsCSSString(iCSSWriterSettings, n));
        }
        if (n2 == 0) {
            stringBuilder.append(bl ? "{}" : " {}\n");
        } else {
            stringBuilder.append(bl ? "{" : " {\n");
            bl2 = true;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                String string = iCSSTopLevelRule.getAsCSSString(iCSSWriterSettings, n + 1);
                if (!StringHelper.hasText((String)string)) continue;
                if (bl2) {
                    bl2 = false;
                } else if (!bl) {
                    stringBuilder.append('\n');
                }
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
                }
                stringBuilder.append(string);
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsRule cSSSupportsRule = (CSSSupportsRule)object;
        return this.m_aConditionMembers.equals(cSSSupportsRule.m_aConditionMembers) && this.m_aRules.equals(cSSSupportsRule.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aConditionMembers).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("conditionMembers", this.m_aConditionMembers).append("rules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

