/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.writer;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableObject;
import com.helger.commons.io.streams.NonBlockingStringWriter;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.string.StringHelper;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.writer.CSSWriterSettings;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSWriter {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    private final CSSWriterSettings m_aSettings;
    private boolean m_bWriteHeaderText;
    private String m_sHeaderText = "THIS FILE IS GENERATED - DO NOT EDIT";
    private boolean m_bWriteFooterText;
    private String m_sFooterText;
    private String m_sContentCharset;

    public CSSWriter(@Nonnull ECSSVersion eCSSVersion) {
        this(eCSSVersion, false);
    }

    public CSSWriter(@Nonnull ECSSVersion eCSSVersion, boolean bl) {
        this(new CSSWriterSettings(eCSSVersion, bl));
    }

    public CSSWriter(@Nonnull CSSWriterSettings cSSWriterSettings) {
        ValueEnforcer.notNull((Object)cSSWriterSettings, (String)"Settings");
        this.m_aSettings = cSSWriterSettings;
        this.m_bWriteHeaderText = !cSSWriterSettings.isOptimizedOutput();
        this.m_bWriteFooterText = !cSSWriterSettings.isOptimizedOutput();
    }

    public boolean isWriteHeaderText() {
        return this.m_bWriteHeaderText;
    }

    @Nonnull
    public CSSWriter setWriteHeaderText(boolean bl) {
        this.m_bWriteHeaderText = bl;
        return this;
    }

    @Nullable
    public String getHeaderText() {
        return this.m_sHeaderText;
    }

    @Nonnull
    public CSSWriter setHeaderText(@Nullable String string) {
        this.m_sHeaderText = string;
        return this;
    }

    public boolean isWriteFooterText() {
        return this.m_bWriteFooterText;
    }

    @Nonnull
    public CSSWriter setWriteFooterText(boolean bl) {
        this.m_bWriteFooterText = bl;
        return this;
    }

    @Nullable
    public String getFooterText() {
        return this.m_sFooterText;
    }

    @Nonnull
    public CSSWriter setFooterText(@Nullable String string) {
        this.m_sFooterText = string;
        return this;
    }

    @Nullable
    public String getContentCharset() {
        return this.m_sContentCharset;
    }

    @Nonnull
    public CSSWriter setContentCharset(@Nullable String string) {
        this.m_sContentCharset = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(reason="Design")
    public CSSWriterSettings getSettings() {
        return this.m_aSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @WillClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)cascadingStyleSheet, (String)"CSS");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        try {
            Iterator<ICSSTopLevelRule> iterator;
            Object object;
            List<CSSImportRule> list22;
            boolean bl = this.m_aSettings.isOptimizedOutput();
            if (this.m_bWriteHeaderText && StringHelper.hasText((String)this.m_sHeaderText)) {
                writer.write("/*\n");
                for (List<CSSImportRule> list22 : StringHelper.getExploded((String)"\n", (String)this.m_sHeaderText)) {
                    writer.write(" * " + (String)((Object)list22) + "\n");
                }
                writer.write(" */\n");
            }
            if (StringHelper.hasText((String)this.m_sContentCharset)) {
                writer.write("@charset \"" + this.m_sContentCharset + "\";");
                if (!bl) {
                    writer.write(10);
                }
            }
            int n = 0;
            list22 = cascadingStyleSheet.getAllImportRules();
            if (!list22.isEmpty()) {
                object = list22.iterator();
                while (object.hasNext()) {
                    iterator = (CSSImportRule)object.next();
                    writer.write(((CSSImportRule)((Object)iterator)).getAsCSSString(this.m_aSettings, 0));
                    ++n;
                }
            }
            if (!(object = cascadingStyleSheet.getAllNamespaceRules()).isEmpty()) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    CSSNamespaceRule object2 = (CSSNamespaceRule)((Object)iterator.next());
                    writer.write(object2.getAsCSSString(this.m_aSettings, 0));
                    ++n;
                }
            }
            for (ICSSTopLevelRule iCSSTopLevelRule : cascadingStyleSheet.getAllRules()) {
                String string = iCSSTopLevelRule.getAsCSSString(this.m_aSettings, 0);
                if (!StringHelper.hasText((String)string)) continue;
                if (!bl && n > 0) {
                    writer.write(10);
                }
                writer.write(string);
                ++n;
            }
            if (this.m_bWriteFooterText && StringHelper.hasText((String)this.m_sFooterText)) {
                writer.write("/*\n");
                for (String string : StringHelper.getExploded((String)"\n", (String)this.m_sFooterText)) {
                    writer.write(" * " + string + "\n");
                }
                writer.write(" */\n");
            }
        }
        finally {
            StreamUtils.close((Closeable)writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CascadingStyleSheet cascadingStyleSheet) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        try {
            this.writeCSS(cascadingStyleSheet, (Writer)nonBlockingStringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Totally unexpected", iOException);
        }
        return nonBlockingStringWriter.getAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull ICSSWriteable iCSSWriteable, @Nonnull @WillClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)iCSSWriteable, (String)"CSS");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        try {
            writer.write(iCSSWriteable.getAsCSSString(this.m_aSettings, 0));
        }
        finally {
            StreamUtils.close((Closeable)writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull ICSSWriteable iCSSWriteable) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        try {
            this.writeCSS(iCSSWriteable, (Writer)nonBlockingStringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Totally unexpected", iOException);
        }
        return nonBlockingStringWriter.getAsString();
    }
}

