/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSupportsConditionMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsConditionNested
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final List<ICSSSupportsConditionMember> m_aMembers = new ArrayList<ICSSSupportsConditionMember>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return !this.m_aMembers.isEmpty();
    }

    @Deprecated
    @Nonnegative
    public int getSupportsMemberCount() {
        return this.getMemberCount();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.notNull((Object)iCSSSupportsConditionMember, (String)"SupportsConditionMember");
        this.m_aMembers.add(iCSSSupportsConditionMember);
        return this;
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnegative int n, @Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSSupportsConditionMember, (String)"SupportsConditionMember");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add(iCSSSupportsConditionMember);
        } else {
            this.m_aMembers.add(n, iCSSSupportsConditionMember);
        }
        return this;
    }

    @Deprecated
    @Nonnull
    public EChange removeSupportsMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        return this.removeMember(iCSSSupportsConditionMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(iCSSSupportsConditionMember));
    }

    @Deprecated
    @Nonnull
    public EChange removeSupportsMember(@Nonnegative int n) {
        return this.removeMember(n);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMembers() {
        if (this.m_aMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.clear();
        return EChange.CHANGED;
    }

    @Deprecated
    @Nullable
    public ICSSSupportsConditionMember getSupportsMemberAtIndex(@Nonnegative int n) {
        return this.getMemberAtIndex(n);
    }

    @Nullable
    public ICSSSupportsConditionMember getMemberAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return null;
        }
        return this.m_aMembers.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSupportsConditionMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("(");
        boolean bl = true;
        for (ICSSSupportsConditionMember iCSSSupportsConditionMember : this.m_aMembers) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(iCSSSupportsConditionMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsConditionNested cSSSupportsConditionNested = (CSSSupportsConditionNested)object;
        return this.m_aMembers.equals(cSSSupportsConditionNested.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

