/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.ICharArrayEncoder;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import java.io.Writer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

@FunctionalInterface
public interface ICharArrayStreamEncoder
extends ICharArrayEncoder {
    @Override
    @Nonnegative
    default public int getMaximumEncodedLength(@Nonnegative int n) {
        return n;
    }

    default public void encode(@Nullable char[] cArray, @Nonnull @WillNotClose Writer writer) {
        if (cArray == null) {
            this.encode(null, 0, 0, writer);
        } else {
            this.encode(cArray, 0, cArray.length, writer);
        }
    }

    public void encode(@Nullable char[] var1, @Nonnegative int var2, @Nonnegative int var3, @Nonnull @WillNotClose Writer var4);

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public char[] getEncoded(@Nullable char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return this.getEncoded(cArray, 0, cArray.length);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public char[] getEncoded(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumEncodedLength(n2));){
            this.encode(cArray, n, n2, nonBlockingStringWriter);
            char[] cArray2 = nonBlockingStringWriter.getAsCharArray();
            return cArray2;
        }
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public char[] getEncoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        return this.getEncoded(cArray, 0, cArray.length);
    }

    @Nullable
    default public String getEncodedAsString(@Nullable char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return this.getEncodedAsString(cArray, 0, cArray.length);
    }

    @Nullable
    default public String getEncodedAsString(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumEncodedLength(n2));){
            this.encode(cArray, n, n2, nonBlockingStringWriter);
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
    }

    @Nullable
    default public String getEncodedAsString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        return this.getEncodedAsString(cArray, 0, cArray.length);
    }
}

