/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.traits.IGetterDirectTrait;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class CommonsMock {
    private static final Map<Class<?>, MockSupplier> s_aStaticSupplier = new WeakHashMap();
    private final Map<Class<?>, MockSupplier> m_aPerInstanceSupplier = new WeakHashMap();

    private static boolean _canRegister(Class<?> clazz) {
        return clazz != Object.class;
    }

    public static <T> void registerStaticConstant(@Nonnull T t) {
        CommonsMock.registerStatic(MockSupplier.createConstant(t));
    }

    public static <T> void registerStatic(@Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
        CommonsMock.registerStatic(MockSupplier.createNoParams(clazz, supplier));
    }

    public static <T> void registerStatic(@Nonnull Class<T> clazz, @Nonnull Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], T> function) {
        CommonsMock.registerStatic(MockSupplier.create(clazz, paramArray, function));
    }

    private static void _register(@Nonnull MockSupplier mockSupplier, @Nonnull Map<Class<?>, MockSupplier> map) {
        ValueEnforcer.notNull(mockSupplier, "Supplier");
        ValueEnforcer.notNull(map, "TargetMap");
        Class clazz = mockSupplier.m_aDstClass;
        if (map.containsKey(clazz)) {
            throw new IllegalArgumentException("A static for class " + clazz.getName() + " is already contained!");
        }
        for (Class clazz2 : ClassHierarchyCache.getClassHierarchy(clazz)) {
            if (!CommonsMock._canRegister(clazz2) || map.containsKey(clazz2)) continue;
            map.put(clazz2, mockSupplier);
        }
    }

    public static void registerStatic(@Nonnull MockSupplier mockSupplier) {
        CommonsMock._register(mockSupplier, s_aStaticSupplier);
    }

    public final <T> void registerPerInstanceConstant(@Nonnull T t) {
        this.registerPerInstance(MockSupplier.createConstant(t));
    }

    public final <T> void registerPerInstance(@Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
        this.registerPerInstance(MockSupplier.createNoParams(clazz, supplier));
    }

    public final <T> void registerPerInstance(@Nonnull Class<T> clazz, @Nonnull Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], T> function) {
        this.registerPerInstance(MockSupplier.create(clazz, paramArray, function));
    }

    public final void registerPerInstance(@Nonnull MockSupplier mockSupplier) {
        CommonsMock._register(mockSupplier, this.m_aPerInstanceSupplier);
    }

    @Nonnull
    private Object _mock(@Nonnull Class<?> clazz, @Nullable Object[] objectArray, int n) throws Exception {
        MockSupplier mockSupplier = s_aStaticSupplier.get(clazz);
        if (mockSupplier != null) {
            return mockSupplier.getMockedValue(objectArray);
        }
        MockSupplier mockSupplier2 = this.m_aPerInstanceSupplier.get(clazz);
        if (mockSupplier2 != null) {
            return mockSupplier2.getMockedValue(objectArray);
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 == Boolean.TYPE) {
                return ArrayHelper.newBooleanArray(new boolean[0]);
            }
            if (clazz2 == Byte.TYPE) {
                return ArrayHelper.newByteArray(new byte[0]);
            }
            if (clazz2 == Character.TYPE) {
                return ArrayHelper.newCharArray(new char[0]);
            }
            if (clazz2 == Double.TYPE) {
                return ArrayHelper.newDoubleArray(new double[0]);
            }
            if (clazz2 == Float.TYPE) {
                return ArrayHelper.newFloatArray(new float[0]);
            }
            if (clazz2 == Integer.TYPE) {
                return ArrayHelper.newIntArray(new int[0]);
            }
            if (clazz2 == Long.TYPE) {
                return ArrayHelper.newLongArray(new long[0]);
            }
            if (clazz2 == Short.TYPE) {
                return ArrayHelper.newShortArray(new short[0]);
            }
            ?[] objArray = ArrayHelper.newArray(clazz2, 1);
            objArray[0] = this._mock(clazz2, null, n + 1);
            return objArray;
        }
        if (clazz.isEnum()) {
            return clazz.getEnumConstants()[0];
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            try {
                Object[] objectArray2 = new Object[constructor.getParameterCount()];
                int n2 = 0;
                for (Class<?> clazz3 : constructor.getParameterTypes()) {
                    objectArray2[n2++] = EqualsHelper.identityEqual(clazz3, clazz) ? null : this._mock(clazz3, null, n + 1);
                }
                return constructor.newInstance(objectArray2);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException("Class " + clazz.getName() + " has no mockable constructor!");
    }

    @Nonnull
    public <T> T mock(@Nonnull Class<T> clazz, Object ... objectArray) {
        try {
            Object DSTTYPE = GenericReflection.uncheckedCast(this._mock(clazz, objectArray, 0));
            if (!this.m_aPerInstanceSupplier.containsKey(clazz)) {
                this.registerPerInstanceConstant(DSTTYPE);
            }
            return (T)DSTTYPE;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to mock class " + clazz.getName(), exception);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public <T> ICommonsList<T> mockMany(@Nonnegative int n, @Nonnull Class<T> clazz, Object ... objectArray) {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(n);
        for (int i = 0; i < n; ++i) {
            commonsArrayList.add(this.mock(clazz, objectArray));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public <T> ICommonsSet<T> mockSet(@Nonnegative int n, @Nonnull Class<T> clazz, Object ... objectArray) {
        CommonsHashSet<int> commonsHashSet = new CommonsHashSet<int>(n);
        for (int i = 0; i < n; ++i) {
            commonsHashSet.add(this.mock(clazz, objectArray));
        }
        return commonsHashSet;
    }

    static {
        s_aStaticSupplier.put(Boolean.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_BOOLEAN_OBJ));
        s_aStaticSupplier.put(Boolean.class, MockSupplier.createConstant(CGlobal.DEFAULT_BOOLEAN_OBJ));
        s_aStaticSupplier.put(Byte.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_BYTE_OBJ));
        s_aStaticSupplier.put(Byte.class, MockSupplier.createConstant(CGlobal.DEFAULT_BYTE_OBJ));
        s_aStaticSupplier.put(Character.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_CHAR_OBJ));
        s_aStaticSupplier.put(Character.class, MockSupplier.createConstant(CGlobal.DEFAULT_CHAR_OBJ));
        s_aStaticSupplier.put(Double.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_DOUBLE_OBJ));
        s_aStaticSupplier.put(Double.class, MockSupplier.createConstant(CGlobal.DEFAULT_DOUBLE_OBJ));
        s_aStaticSupplier.put(Float.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_FLOAT_OBJ));
        s_aStaticSupplier.put(Float.class, MockSupplier.createConstant(CGlobal.DEFAULT_FLOAT_OBJ));
        s_aStaticSupplier.put(Integer.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_INT_OBJ));
        s_aStaticSupplier.put(Integer.class, MockSupplier.createConstant(CGlobal.DEFAULT_INT_OBJ));
        s_aStaticSupplier.put(Long.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_LONG_OBJ));
        s_aStaticSupplier.put(Long.class, MockSupplier.createConstant(CGlobal.DEFAULT_LONG_OBJ));
        s_aStaticSupplier.put(Short.TYPE, MockSupplier.createConstant(CGlobal.DEFAULT_SHORT_OBJ));
        s_aStaticSupplier.put(Short.class, MockSupplier.createConstant(CGlobal.DEFAULT_SHORT_OBJ));
        Supplier<String> supplier = new Supplier<String>(){
            private final AtomicInteger m_aCount = new AtomicInteger(0);

            @Override
            @Nonnull
            @Nonempty
            public String get() {
                return "str" + this.m_aCount.incrementAndGet();
            }
        };
        CommonsMock.registerStatic(String.class, supplier);
        CommonsMock.registerStatic(LocalDate.class, PDTFactory::getCurrentLocalDate);
        CommonsMock.registerStatic(LocalTime.class, PDTFactory::getCurrentLocalTime);
        CommonsMock.registerStatic(LocalDateTime.class, PDTFactory::getCurrentLocalDateTime);
        CommonsMock.registerStatic(OffsetDateTime.class, PDTFactory::getCurrentOffsetDateTime);
        CommonsMock.registerStatic(ZonedDateTime.class, PDTFactory::getCurrentZonedDateTime);
        CommonsMock.registerStaticConstant(BigDecimal.ZERO);
        CommonsMock.registerStaticConstant(BigInteger.ZERO);
    }

    private static final class MockSupplier {
        private final Class<?> m_aDstClass;
        private final Param[] m_aParams;
        private final Function<IGetterDirectTrait[], ?> m_aFct;

        private MockSupplier(@Nonnull Class<?> clazz, @Nullable Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], ?> function) {
            this.m_aDstClass = clazz;
            this.m_aParams = paramArray;
            this.m_aFct = function;
        }

        @Nullable
        public Object getMockedValue(@Nullable Object[] objectArray) {
            IGetterDirectTrait[] iGetterDirectTraitArray = null;
            if (this.m_aParams != null && this.m_aParams.length > 0) {
                int n = this.m_aParams.length;
                int n2 = ArrayHelper.getSize(objectArray);
                iGetterDirectTraitArray = new IGetterDirectTrait[n];
                for (int i = 0; i < n; ++i) {
                    if (i < n2 && objectArray[i] != null) {
                        Object object = objectArray[i];
                        iGetterDirectTraitArray[i] = () -> object;
                        continue;
                    }
                    iGetterDirectTraitArray[i] = this.m_aParams[i].getDefaultValue();
                }
            }
            return this.m_aFct.apply(iGetterDirectTraitArray);
        }

        @Nonnull
        public static MockSupplier createConstant(@Nonnull Object object) {
            ValueEnforcer.notNull(object, "Constant");
            return new MockSupplier(object.getClass(), null, iGetterDirectTraitArray -> object);
        }

        @Nonnull
        public static <T> MockSupplier createNoParams(@Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
            ValueEnforcer.notNull(clazz, "DstClass");
            ValueEnforcer.notNull(supplier, "Supplier");
            return new MockSupplier(clazz, null, iGetterDirectTraitArray -> supplier.get());
        }

        @Nonnull
        public static <T> MockSupplier create(@Nonnull Class<T> clazz, @Nonnull Param[] paramArray, @Nonnull Function<IGetterDirectTrait[], T> function) {
            ValueEnforcer.notNull(clazz, "DstClass");
            ValueEnforcer.notNull(paramArray, "Params");
            ValueEnforcer.notNull(function, "Supplier");
            return new MockSupplier(clazz, paramArray, function);
        }
    }

    @Immutable
    public static final class Param {
        private final String m_sParamName;
        private final Class<?> m_aParamClass;
        private final Supplier<?> m_aDefaultValueSupplier;

        public <T> Param(@Nonnull @Nonempty String string, @Nonnull Class<T> clazz, @Nonnull Supplier<T> supplier) {
            this.m_sParamName = ValueEnforcer.notEmpty(string, "ParamName");
            this.m_aParamClass = ValueEnforcer.notNull(clazz, "ParamClass");
            this.m_aDefaultValueSupplier = ValueEnforcer.notNull(supplier, "DefaultValueSupplier");
        }

        @Nonnull
        @Nonempty
        public String getParamName() {
            return this.m_sParamName;
        }

        @Nonnull
        public Class<?> getParamClass() {
            return this.m_aParamClass;
        }

        @Nonnull
        public IGetterDirectTrait getDefaultValue() {
            Object obj = this.m_aDefaultValueSupplier.get();
            return () -> obj;
        }

        public String toString() {
            return ClassHelper.getClassLocalName(this.m_aParamClass) + ":" + this.m_sParamName;
        }

        @Nonnull
        public static Param createConstant(@Nonnull @Nonempty String string, boolean bl) {
            return Param.createConstant(string, Boolean.TYPE, bl);
        }

        @Nonnull
        public static <T> Param createConstant(@Nonnull @Nonempty String string, @Nonnull Class<T> clazz, @Nullable T t) {
            return new Param(string, clazz, () -> t);
        }
    }
}

