/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.ICloneable;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CloneHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloneHelper.class);
    private static final CloneHelper s_aInstance = new CloneHelper();

    private CloneHelper() {
    }

    @Nullable
    private static <DATATYPE> DATATYPE _getGenericClone(@Nonnull DATATYPE DATATYPE) {
        if (DATATYPE instanceof ICloneable) {
            return ((ICloneable)GenericReflection.uncheckedCast(DATATYPE)).getClone();
        }
        try {
            return (DATATYPE)GenericReflection.invokeMethod(DATATYPE, "clone", new Object[0]);
        }
        catch (Exception exception) {
            block11: {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Failed to invoke clone on " + DATATYPE.getClass().getName());
                }
                try {
                    Constructor<DATATYPE> constructor = GenericReflection.findConstructor(DATATYPE, DATATYPE.getClass());
                    if (constructor != null) {
                        return constructor.newInstance(DATATYPE);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor or the methods are invisible.");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a clone method nor a (visible) copy constructor or the methods are invisible.");
                    }
                }
                catch (Exception exception2) {
                    if (!LOGGER.isErrorEnabled()) break block11;
                    LOGGER.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor.", (Throwable)exception2);
                }
            }
            return null;
        }
    }

    @Nullable
    public static <DATATYPE> DATATYPE getClonedValue(@Nullable DATATYPE DATATYPE) {
        if (DATATYPE == null) {
            return null;
        }
        Class<?> clazz = DATATYPE.getClass();
        if (ClassHelper.isPrimitiveWrapperType(clazz) || DATATYPE instanceof String || clazz.getAnnotation(Immutable.class) != null) {
            return DATATYPE;
        }
        return CloneHelper._getGenericClone(DATATYPE);
    }

    @Nullable
    public static <DATATYPE extends ICloneable<DATATYPE>> DATATYPE getCloneIfNotNull(@Nullable DATATYPE DATATYPE) {
        if (DATATYPE == null) {
            return null;
        }
        return (DATATYPE)((ICloneable)DATATYPE.getClone());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <DATATYPE> ICommonsList<DATATYPE> getGenericClonedList(@Nullable Iterable<DATATYPE> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iterable != null) {
            for (DATATYPE DATATYPE : iterable) {
                commonsArrayList.add(CloneHelper.getClonedValue(DATATYPE));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <DATATYPE extends ICloneable<DATATYPE>> ICommonsList<DATATYPE> getClonedList(@Nullable Iterable<DATATYPE> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iterable != null) {
            for (ICloneable iCloneable : iterable) {
                commonsArrayList.add(CloneHelper.getCloneIfNotNull(iCloneable));
            }
        }
        return commonsArrayList;
    }
}

