/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale.language;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LanguageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageCache.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aLanguages = new CommonsHashSet<String>();

    private LanguageCache() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static LanguageCache getInstance() {
        LanguageCache languageCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return languageCache;
    }

    @Nonnull
    EChange addLanguage(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Language");
        String string2 = LocaleHelper.getValidLanguageCode(string);
        ValueEnforcer.isTrue(string2 != null, () -> "illegal language code '" + string + "'");
        ValueEnforcer.isEqual(string, string2, () -> "invalid casing of '" + string + "'");
        return this.m_aRWLock.writeLocked(() -> this.m_aLanguages.addObject(string2));
    }

    @Nullable
    public Locale getLanguage(@Nullable Locale locale) {
        return locale == null ? null : this.getLanguage(locale.getLanguage());
    }

    @Nullable
    public Locale getLanguage(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        if (string.indexOf(95) >= 0) {
            return this.getLanguage(LocaleCache.getInstance().getLocale(string));
        }
        String string2 = LocaleHelper.getValidLanguageCode(string);
        if (!this.containsLanguage(string2) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Trying to retrieve unsupported language '" + string + "'");
        }
        return LocaleCache.getInstance().getLocale(string2, "", "");
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllLanguages() {
        return this.m_aRWLock.readLocked(this.m_aLanguages::getClone);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<Locale> getAllLanguageLocales() {
        return this.m_aRWLock.readLocked(() -> {
            LocaleCache localeCache = LocaleCache.getInstance();
            return new CommonsHashSet<Locale>(this.m_aLanguages, string -> localeCache.getLocale((String)string, "", ""));
        });
    }

    public boolean containsLanguage(@Nullable Locale locale) {
        return locale != null && this.containsLanguage(locale.getLanguage());
    }

    public boolean containsLanguage(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = LocaleHelper.getValidLanguageCode(string);
        if (string2 == null) {
            return false;
        }
        return this.m_aRWLock.readLocked(() -> this.m_aLanguages.contains(string2));
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(this.m_aLanguages::clear);
        for (Locale locale : LocaleCache.getInstance().getAllLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.hasText(string)) continue;
            this.addLanguage(string);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + LanguageCache.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final LanguageCache s_aInstance = new LanguageCache();

        private SingletonHolder() {
        }
    }
}

