/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.pool;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.pool.IMutableObjectPool;
import com.helger.commons.state.ESuccess;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ObjectPool<DATATYPE>
implements IMutableObjectPool<DATATYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ObjectPool.class);
    private final SimpleLock m_aLock = new SimpleLock();
    private final Semaphore m_aAvailable;
    private final Object[] m_aItems;
    private final boolean[] m_aUsed;
    private final ISupplier<? extends DATATYPE> m_aFactory;

    public ObjectPool(@Nonnegative int n, @Nonnull ISupplier<? extends DATATYPE> iSupplier) {
        ValueEnforcer.isGT0(n, "ItemCount");
        ValueEnforcer.notNull(iSupplier, "Factory");
        this.m_aAvailable = new Semaphore(n);
        this.m_aItems = new Object[n];
        this.m_aUsed = new boolean[n];
        Arrays.fill(this.m_aUsed, 0, n, false);
        this.m_aFactory = iSupplier;
    }

    public void clearUnusedItems() {
        this.m_aLock.locked(() -> {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (this.m_aUsed[i]) continue;
                this.m_aItems[i] = null;
            }
        });
    }

    @Override
    @Nullable
    public DATATYPE borrowObject() {
        try {
            this.m_aAvailable.acquire();
        }
        catch (InterruptedException interruptedException) {
            s_aLogger.error("ObjectPool interrupted", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
            return null;
        }
        return (DATATYPE)this.m_aLock.locked(() -> {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (this.m_aUsed[i]) continue;
                if (this.m_aItems[i] == null) {
                    this.m_aItems[i] = this.m_aFactory.get();
                    if (this.m_aItems[i] == null) {
                        throw new IllegalStateException("The factory returned a null object!");
                    }
                }
                this.m_aUsed[i] = true;
                return GenericReflection.uncheckedCast(this.m_aItems[i]);
            }
            throw new IllegalStateException("Should never be reached!");
        });
    }

    @Override
    @Nonnull
    public ESuccess returnObject(@Nonnull DATATYPE DATATYPE) {
        return this.m_aLock.locked(() -> {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (!this.m_aUsed[i] || DATATYPE != this.m_aItems[i]) continue;
                this.m_aUsed[i] = false;
                this.m_aAvailable.release();
                return ESuccess.SUCCESS;
            }
            s_aLogger.warn("Object " + DATATYPE + " is not pooled!");
            return ESuccess.FAILURE;
        });
    }
}

