/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.collection.multimap.MultiLinkedHashMapArrayListBased;
import com.helger.commons.url.URLParameter;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class URLParameterList
extends CommonsArrayList<URLParameter> {
    public URLParameterList() {
    }

    public URLParameterList(@Nullable List<? extends URLParameter> list) {
        super(list);
    }

    @Nonnull
    public URLParameterList add(@Nonnull @Nonempty String string) {
        return this.add(string, "");
    }

    @Nonnull
    public URLParameterList add(@Nonnull Map.Entry<String, String> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public URLParameterList add(@Nonnull @Nonempty String string, boolean bl) {
        return this.add(string, Boolean.toString(bl));
    }

    @Nonnull
    public URLParameterList add(@Nonnull @Nonempty String string, int n) {
        return this.add(string, Integer.toString(n));
    }

    @Nonnull
    public URLParameterList add(@Nonnull @Nonempty String string, long l) {
        return this.add(string, Long.toString(l));
    }

    @Nonnull
    public URLParameterList add(@Nonnull @Nonempty String string, @Nonnull BigInteger bigInteger) {
        return this.add(string, bigInteger.toString());
    }

    @Nonnull
    public URLParameterList add(@Nonnull @Nonempty String string, @Nonnull String string2) {
        this.add(new URLParameter(string, string2));
        return this;
    }

    @Nonnull
    public final URLParameterList addAll(@Nullable Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.add(entry);
            }
        }
        return this;
    }

    @Nonnull
    public final URLParameterList addAll(@Nullable List<? extends URLParameter> list) {
        if (list != null) {
            for (URLParameter uRLParameter : list) {
                this.add(uRLParameter);
            }
        }
        return this;
    }

    @Nonnull
    public URLParameterList addAll(@Nonnull @Nonempty String string, String ... stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.add(string, string2);
            }
        }
        return this;
    }

    @Nonnull
    public URLParameterList remove(@Nullable String string) {
        this.removeIf(uRLParameter -> uRLParameter.hasName(string));
        return this;
    }

    @Nonnull
    public URLParameterList remove(@Nullable String string, @Nullable String string2) {
        this.removeIf(uRLParameter -> uRLParameter.hasName(string) && uRLParameter.hasValue(string2));
        return this;
    }

    public boolean contains(@Nullable String string) {
        return string != null && this.containsAny(uRLParameter -> uRLParameter.hasName(string));
    }

    public boolean contains(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && this.containsAny(uRLParameter -> uRLParameter.hasName(string) && uRLParameter.hasValue(string2));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllParamNames() {
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        this.forEach((? super E uRLParameter) -> commonsLinkedHashSet.add(uRLParameter.getName()));
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllParamValues(@Nullable String string) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        if (string != null) {
            this.findAll(uRLParameter -> uRLParameter.hasName(string), uRLParameter -> commonsArrayList.add(uRLParameter.getValue()));
        }
        return commonsArrayList;
    }

    @Nullable
    public String getFirstParamValue(@Nullable String string) {
        return string == null ? null : this.findFirstMapped(uRLParameter -> uRLParameter.hasName(string), uRLParameter -> uRLParameter.getValue());
    }

    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, String> getAsMultiMap() {
        MultiLinkedHashMapArrayListBased<String, String> multiLinkedHashMapArrayListBased = new MultiLinkedHashMapArrayListBased<String, String>();
        this.forEach((? super E uRLParameter) -> multiLinkedHashMapArrayListBased.putSingle(uRLParameter.getName(), uRLParameter.getValue()));
        return multiLinkedHashMapArrayListBased;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public URLParameterList getClone() {
        return new URLParameterList(this);
    }
}

