/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLParameterList;
import com.helger.commons.url.URLProtocolRegistry;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IURLData
extends Serializable {
    @Nullable
    default public IURLProtocol getProtocol() {
        return URLProtocolRegistry.getInstance().getProtocol(this.getPath());
    }

    default public boolean hasKnownProtocol() {
        return URLProtocolRegistry.getInstance().hasKnownProtocol(this.getPath());
    }

    @Nonnull
    public String getPath();

    public boolean hasParams();

    @Nonnegative
    public int getParamCount();

    @Nullable
    @ReturnsMutableObject(value="design")
    public URLParameterList directGetAllParams();

    @Nonnull
    @ReturnsMutableCopy
    public URLParameterList getAllParams();

    public boolean containsParam(@Nullable String var1);

    @Nullable
    public String getParam(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllParams(@Nullable String var1);

    @Nullable
    public String getAnchor();

    default public boolean hasAnchor() {
        return StringHelper.hasText(this.getAnchor());
    }

    default public boolean hasAnchor(@Nullable String string) {
        return EqualsHelper.equals(string, this.getAnchor());
    }
}

