/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.scope.mgr.DefaultScopeFactory;
import com.helger.commons.scope.mgr.IScopeFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetaScopeFactory {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IScopeFactory s_aScopeFactory = new DefaultScopeFactory();

    private MetaScopeFactory() {
    }

    public static void setScopeFactory(@Nonnull IScopeFactory iScopeFactory) {
        ValueEnforcer.notNull(iScopeFactory, "ScopeFactory");
        s_aRWLock.writeLocked(() -> {
            s_aScopeFactory = iScopeFactory;
            return s_aScopeFactory;
        });
    }

    @Nonnull
    public static IScopeFactory getScopeFactory() {
        return s_aRWLock.readLocked(() -> s_aScopeFactory);
    }
}

