/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mutable;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.mutable.AbstractMutableNumeric;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableBigDecimal
extends AbstractMutableNumeric<MutableBigDecimal> {
    @Deprecated
    public static final BigDecimal DEFAULT_VALUE = BigDecimal.ZERO;
    private BigDecimal m_aValue;

    @Deprecated
    public MutableBigDecimal() {
        this(DEFAULT_VALUE);
    }

    public MutableBigDecimal(long l) {
        this(MathHelper.toBigDecimal(l));
    }

    public MutableBigDecimal(double d) {
        this(MathHelper.toBigDecimal(d));
    }

    public MutableBigDecimal(@Nonnull MutableBigDecimal mutableBigDecimal) {
        this(mutableBigDecimal.m_aValue);
    }

    public MutableBigDecimal(@Nonnull BigDecimal bigDecimal) {
        this.m_aValue = ValueEnforcer.notNull(bigDecimal, "Value");
    }

    @Override
    @Nonnull
    public BigDecimal getAsBigDecimal() {
        return this.m_aValue;
    }

    @Override
    public double doubleValue() {
        return this.m_aValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.m_aValue.floatValue();
    }

    @Override
    public int intValue() {
        return this.m_aValue.intValue();
    }

    @Override
    public long longValue() {
        return this.m_aValue.longValue();
    }

    @Nonnull
    public BigDecimal inc() {
        return this.inc(BigDecimal.ONE);
    }

    @Nonnull
    public BigDecimal inc(long l) {
        return this.inc(MathHelper.toBigDecimal(l));
    }

    @Nonnull
    public BigDecimal inc(double d) {
        return this.inc(MathHelper.toBigDecimal(d));
    }

    @Nonnull
    public BigDecimal inc(@Nonnull MutableBigDecimal mutableBigDecimal) {
        ValueEnforcer.notNull(mutableBigDecimal, "Delta");
        return this.inc(mutableBigDecimal.m_aValue);
    }

    @Nonnull
    public BigDecimal inc(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull(bigDecimal, "Delta");
        this.m_aValue = this.m_aValue.add(bigDecimal);
        this.onAfterChange();
        return this.m_aValue;
    }

    @Nonnull
    public BigDecimal dec() {
        return this.inc(CGlobal.BIGDEC_MINUS_ONE);
    }

    @Nonnull
    public BigDecimal dec(long l) {
        return this.inc(MathHelper.toBigDecimal(-l));
    }

    @Nonnull
    public BigDecimal dec(double d) {
        return this.inc(MathHelper.toBigDecimal(-d));
    }

    @Nonnull
    public BigDecimal dec(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull(bigDecimal, "Delta");
        return this.inc(bigDecimal.negate());
    }

    @Nonnull
    public BigDecimal dec(@Nonnull MutableBigDecimal mutableBigDecimal) {
        ValueEnforcer.notNull(mutableBigDecimal, "Delta");
        return this.inc(mutableBigDecimal.m_aValue.negate());
    }

    @Nonnull
    public BigDecimal divide(long l, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return this.divide(MathHelper.toBigDecimal(l), n, roundingMode);
    }

    @Nonnull
    public BigDecimal divide(double d, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return this.divide(MathHelper.toBigDecimal(d), n, roundingMode);
    }

    @Nonnull
    public BigDecimal divide(@Nonnull MutableBigDecimal mutableBigDecimal, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        ValueEnforcer.notNull(mutableBigDecimal, "Divisor");
        return this.divide(mutableBigDecimal.m_aValue, n, roundingMode);
    }

    @Nonnull
    public BigDecimal divide(@Nonnull BigDecimal bigDecimal, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        ValueEnforcer.notNull(bigDecimal, "Divisor");
        this.m_aValue = this.m_aValue.divide(bigDecimal, n, roundingMode);
        this.onAfterChange();
        return this.m_aValue;
    }

    @Nonnull
    public BigDecimal multiply(long l) {
        return this.multiply(MathHelper.toBigDecimal(l));
    }

    @Nonnull
    public BigDecimal multiply(double d) {
        return this.multiply(MathHelper.toBigDecimal(d));
    }

    @Nonnull
    public BigDecimal multiply(@Nonnull MutableBigDecimal mutableBigDecimal) {
        ValueEnforcer.notNull(mutableBigDecimal, "Multiplicand");
        return this.multiply(mutableBigDecimal.m_aValue);
    }

    @Nonnull
    public BigDecimal multiply(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull(bigDecimal, "Multiplicand");
        this.m_aValue = this.m_aValue.multiply(bigDecimal);
        this.onAfterChange();
        return this.m_aValue;
    }

    @Nonnull
    public EChange set(long l) {
        return this.set(MathHelper.toBigDecimal(l));
    }

    @Nonnull
    public EChange set(double d) {
        return this.set(MathHelper.toBigDecimal(d));
    }

    @Nonnull
    public EChange set(@Nonnull MutableBigDecimal mutableBigDecimal) {
        ValueEnforcer.notNull(mutableBigDecimal, "Value");
        return this.set(mutableBigDecimal.m_aValue);
    }

    @Nonnull
    public EChange set(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull(bigDecimal, "Value");
        if (bigDecimal.equals(this.m_aValue)) {
            return EChange.UNCHANGED;
        }
        this.m_aValue = bigDecimal;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return MathHelper.isEQ0(this.m_aValue);
    }

    @Override
    public boolean isLT0() {
        return MathHelper.isLT0(this.m_aValue);
    }

    @Override
    public boolean isLE0() {
        return MathHelper.isLE0(this.m_aValue);
    }

    @Override
    public boolean isGT0() {
        return MathHelper.isGT0(this.m_aValue);
    }

    @Override
    public boolean isGE0() {
        return MathHelper.isGE0(this.m_aValue);
    }

    @Override
    public int compareTo(@Nonnull MutableBigDecimal mutableBigDecimal) {
        return this.m_aValue.compareTo(mutableBigDecimal.m_aValue);
    }

    @Override
    @Nonnull
    public MutableBigDecimal getClone() {
        return new MutableBigDecimal(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableBigDecimal mutableBigDecimal = (MutableBigDecimal)object;
        return EqualsHelper.equals(this.m_aValue, mutableBigDecimal.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).getToString();
    }
}

