/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.inmemory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.resource.inmemory.AbstractMemoryReadableResource;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ReadableResourceByteArray
extends AbstractMemoryReadableResource
implements IHasSize {
    private final byte[] m_aBytes;

    public ReadableResourceByteArray(@Nonnull byte[] byArray) {
        this.m_aBytes = ArrayHelper.getCopy(ValueEnforcer.notNull(byArray, "Schematron"));
    }

    @Override
    @Nonnull
    @Nonempty
    public String getResourceID() {
        return "byte[]";
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aBytes);
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAllBytes() {
        return ArrayHelper.getCopy(this.m_aBytes);
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.m_aBytes.length;
    }

    @Override
    public boolean isEmpty() {
        return this.m_aBytes.length == 0;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("byte#", this.m_aBytes.length).getToString();
    }
}

