/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.monitor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.monitor.FileMonitor;
import com.helger.commons.io.monitor.FileMonitorAgent;
import com.helger.commons.io.monitor.IFileMonitorCallback;
import com.helger.commons.state.EChange;
import com.helger.commons.thread.ThreadHelper;
import com.helger.commons.timing.StopWatch;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileMonitorManager
implements Runnable {
    public static final long DEFAULT_DELAY = 1000L;
    public static final int DEFAULT_MAX_FILES = 1000;
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileMonitorManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsList<FileMonitor> m_aMonitorList = new CommonsArrayList<FileMonitor>();
    private Thread m_aMonitorThread;
    private volatile boolean m_bShouldRun = true;
    private long m_nDelay = 1000L;
    private int m_nChecksPerRun = 1000;

    public long getDelay() {
        return this.m_nDelay;
    }

    @Nonnull
    public FileMonitorManager setDelay(long l) {
        this.m_nDelay = l > 0L ? l : 1000L;
        return this;
    }

    public int getChecksPerRun() {
        return this.m_nChecksPerRun;
    }

    @Nonnull
    public FileMonitorManager setChecksPerRun(int n) {
        this.m_nChecksPerRun = n;
        return this;
    }

    @Nonnull
    public FileMonitor createFileMonitor(@Nonnull IFileMonitorCallback iFileMonitorCallback) {
        FileMonitor fileMonitor = new FileMonitor(iFileMonitorCallback);
        this.addFileMonitor(fileMonitor);
        return fileMonitor;
    }

    @Nonnull
    public EChange addFileMonitor(@Nonnull FileMonitor fileMonitor) {
        ValueEnforcer.notNull(fileMonitor, "Monitor");
        return this.m_aRWLock.writeLocked(() -> this.m_aMonitorList.addObject(fileMonitor));
    }

    @Nonnull
    public EChange removeFileMonitor(@Nullable FileMonitor fileMonitor) {
        if (fileMonitor == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aRWLock.writeLocked(() -> this.m_aMonitorList.removeObject(fileMonitor));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<FileMonitor> getAllFileMonitors() {
        return this.m_aRWLock.readLocked(() -> (ICommonsList)this.m_aMonitorList.getClone());
    }

    @Nonnegative
    public int getFileMonitorCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aMonitorList.size());
    }

    public void start() {
        if (this.m_aMonitorThread != null || !this.m_bShouldRun) {
            throw new IllegalStateException("Thread is already running!");
        }
        this.m_aMonitorThread = new Thread((Runnable)this, "ph-FileMonitor");
        this.m_aMonitorThread.setDaemon(true);
        this.m_aMonitorThread.setPriority(1);
        this.m_aMonitorThread.start();
        s_aLogger.info("Started FileMonitor thread");
    }

    public void stop() {
        if (this.m_aMonitorThread != null) {
            this.m_bShouldRun = false;
            this.m_aMonitorThread = null;
            s_aLogger.info("Stopped FileMonitor thread");
        }
    }

    public boolean isRunning() {
        return this.m_aMonitorThread != null && this.m_bShouldRun;
    }

    @Override
    public void run() {
        block0: while (this.m_aMonitorThread != null && !this.m_aMonitorThread.isInterrupted() && this.m_bShouldRun) {
            StopWatch stopWatch = StopWatch.createdStarted();
            int n = 0;
            for (FileMonitor fileMonitor : this.getAllFileMonitors()) {
                fileMonitor.applyPendingDeletes();
                for (FileMonitorAgent fileMonitorAgent : fileMonitor.getAllAgents()) {
                    fileMonitorAgent.checkForModifications();
                    int n2 = this.getChecksPerRun();
                    if (n2 > 0 && n % n2 == 0) {
                        ThreadHelper.sleep(this.getDelay());
                    }
                    if (this.m_aMonitorThread == null || this.m_aMonitorThread.isInterrupted() || !this.m_bShouldRun) break block0;
                    ++n;
                }
                fileMonitor.applyPendingAdds();
            }
            ThreadHelper.sleep(this.getDelay());
            if (!s_aLogger.isDebugEnabled()) continue;
            s_aLogger.debug("Checking for file modifications took " + stopWatch.stopAndGetMillis() + " ms");
        }
        this.m_bShouldRun = true;
    }
}

