/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.hashcode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UseDirectEqualsAndHashCode;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.CommonsWeakHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.hashcode.IHashCodeImplementation;
import com.helger.commons.hashcode.IHashCodeImplementationRegistrarSPI;
import com.helger.commons.hashcode.IHashCodeImplementationRegistry;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.state.EChange;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HashCodeImplementationRegistry
implements IHashCodeImplementationRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(HashCodeImplementationRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<Class<?>, IHashCodeImplementation> m_aMap = new CommonsWeakHashMap();
    private final AnnotationUsageCache m_aDirectHashCode = new AnnotationUsageCache(UseDirectEqualsAndHashCode.class);
    private final ICommonsMap<String, Boolean> m_aImplementsHashCode = new CommonsHashMap<String, Boolean>();

    private HashCodeImplementationRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static HashCodeImplementationRegistry getInstance() {
        HashCodeImplementationRegistry hashCodeImplementationRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return hashCodeImplementationRegistry;
    }

    @Override
    public void registerHashCodeImplementation(@Nonnull Class<?> clazz, @Nonnull IHashCodeImplementation iHashCodeImplementation) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iHashCodeImplementation, "Implementation");
        if (clazz.equals(Object.class)) {
            throw new IllegalArgumentException("You cannot provide a hashCode implementation for Object.class!");
        }
        this.m_aRWLock.writeLocked(() -> {
            IHashCodeImplementation iHashCodeImplementation2 = (IHashCodeImplementation)this.m_aMap.get(clazz);
            if (iHashCodeImplementation2 == null) {
                this.m_aMap.put(clazz, iHashCodeImplementation);
            } else if (!EqualsHelper.identityEqual(iHashCodeImplementation2, iHashCodeImplementation)) {
                s_aLogger.warn("Another hashCode implementation for class " + clazz + " is already registered (" + iHashCodeImplementation2.toString() + ") so it is not overwritten with " + iHashCodeImplementation.toString());
            }
        });
    }

    @Nonnull
    public EChange unregisterHashCodeImplementation(@Nonnull Class<?> clazz) {
        return this.m_aRWLock.writeLocked(() -> this.m_aMap.removeObject(clazz));
    }

    private boolean _isUseDirectHashCode(@Nonnull Class<?> clazz) {
        return this.m_aDirectHashCode.hasAnnotation(clazz);
    }

    private boolean _implementsHashCodeItself(@Nonnull Class<?> clazz) {
        String string = clazz.getName();
        Boolean bl = this.m_aRWLock.readLocked(() -> (Boolean)this.m_aImplementsHashCode.get(string));
        if (bl == null) {
            bl = this.m_aRWLock.writeLocked(() -> {
                Boolean bl = (Boolean)this.m_aImplementsHashCode.get(string);
                if (bl == null) {
                    boolean bl2 = false;
                    try {
                        Method method = clazz.getDeclaredMethod("hashCode", new Class[0]);
                        if (method != null && method.getReturnType().equals(Integer.TYPE)) {
                            bl2 = true;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    bl = bl2;
                    this.m_aImplementsHashCode.put(string, bl);
                }
                return bl;
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IHashCodeImplementation getBestMatchingHashCodeImplementation(@Nullable Class<?> clazz) {
        if (clazz != null) {
            Class clazz2;
            IHashCodeImplementation iHashCodeImplementation;
            block13: {
                iHashCodeImplementation = null;
                clazz2 = null;
                if (this._isUseDirectHashCode(clazz)) {
                    return null;
                }
                this.m_aRWLock.readLock().lock();
                try {
                    iHashCodeImplementation = (IHashCodeImplementation)this.m_aMap.get(clazz);
                    if (iHashCodeImplementation != null) {
                        clazz2 = clazz;
                        break block13;
                    }
                    for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                        IHashCodeImplementation iHashCodeImplementation2;
                        Class clazz3 = (Class)weakReference.get();
                        if (clazz3 == null || (iHashCodeImplementation2 = (IHashCodeImplementation)this.m_aMap.get(clazz3)) == null) continue;
                        iHashCodeImplementation = iHashCodeImplementation2;
                        clazz2 = clazz3;
                        if (s_aLogger.isDebugEnabled()) {
                            s_aLogger.debug("Found hierarchical match with class " + clazz2 + " when searching for " + clazz);
                        }
                        break;
                    }
                }
                finally {
                    this.m_aRWLock.readLock().unlock();
                }
            }
            if (iHashCodeImplementation != null) {
                if (ClassHelper.isInterface(clazz2) && this._implementsHashCodeItself(clazz)) {
                    this.m_aDirectHashCode.setAnnotation(clazz, true);
                    return null;
                }
                if (!clazz2.equals(clazz)) {
                    this.registerHashCodeImplementation(clazz, iHashCodeImplementation);
                }
                return iHashCodeImplementation;
            }
            if (ClassHelper.isArrayClass(clazz)) {
                return new ArrayHashCodeImplementation();
            }
            this.m_aDirectHashCode.setAnnotation(clazz, true);
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Found no hashCode implementation for " + clazz);
        }
        return null;
    }

    public static int getHashCode(@Nullable Object object) {
        if (object == null) {
            return 129;
        }
        Class<?> clazz = object.getClass();
        IHashCodeImplementation iHashCodeImplementation = HashCodeImplementationRegistry.getInstance().getBestMatchingHashCodeImplementation(clazz);
        return iHashCodeImplementation == null ? object.hashCode() : iHashCodeImplementation.getHashCode(object);
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMap.clear();
            this.m_aDirectHashCode.clearCache();
            this.m_aImplementsHashCode.clear();
        });
        for (IHashCodeImplementationRegistrarSPI iHashCodeImplementationRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IHashCodeImplementationRegistrarSPI.class)) {
            iHashCodeImplementationRegistrarSPI.registerHashCodeImplementations(this);
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Reinitialized " + HashCodeImplementationRegistry.class.getName());
        }
    }

    private static final class ArrayHashCodeImplementation
    implements IHashCodeImplementation {
        @Override
        public int getHashCode(Object object) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(objectArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class SingletonHolder {
        private static final HashCodeImplementationRegistry s_aInstance = new HashCodeImplementationRegistry();

        private SingletonHolder() {
        }
    }
}

