/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.pair;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.pair.IMutablePair;
import com.helger.commons.collection.pair.IPair;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Pair<DATA1TYPE, DATA2TYPE>
implements IMutablePair<DATA1TYPE, DATA2TYPE>,
ICloneable<Pair<DATA1TYPE, DATA2TYPE>> {
    private DATA1TYPE m_aFirst;
    private DATA2TYPE m_aSecond;

    public Pair() {
        this(null, null);
    }

    public <T2 extends DATA1TYPE, U2 extends DATA2TYPE> Pair(@Nullable T2 T2, @Nullable U2 U2) {
        this.m_aFirst = T2;
        this.m_aSecond = U2;
    }

    public Pair(@Nonnull IPair<? extends DATA1TYPE, ? extends DATA2TYPE> iPair) {
        ValueEnforcer.notNull(iPair, "Pair");
        this.m_aFirst = iPair.getFirst();
        this.m_aSecond = iPair.getSecond();
    }

    @Override
    @Nullable
    public DATA1TYPE getFirst() {
        return this.m_aFirst;
    }

    @Override
    @Nonnull
    public EChange setFirst(@Nullable DATA1TYPE DATA1TYPE) {
        if (EqualsHelper.equals(DATA1TYPE, this.m_aFirst)) {
            return EChange.UNCHANGED;
        }
        this.m_aFirst = DATA1TYPE;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public DATA2TYPE getSecond() {
        return this.m_aSecond;
    }

    @Override
    @Nonnull
    public EChange setSecond(@Nullable DATA2TYPE DATA2TYPE) {
        if (EqualsHelper.equals(DATA2TYPE, this.m_aSecond)) {
            return EChange.UNCHANGED;
        }
        this.m_aSecond = DATA2TYPE;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public Pair<DATA1TYPE, DATA2TYPE> getClone() {
        return new Pair<DATA1TYPE, DATA2TYPE>(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Pair pair = (Pair)object;
        return EqualsHelper.equals(this.m_aFirst, pair.m_aFirst) && EqualsHelper.equals(this.m_aSecond, pair.m_aSecond);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).getToString();
    }

    @Nonnull
    public static <T, U> Pair<T, U> create(@Nullable T t, @Nullable U u) {
        return new Pair(t, u);
    }
}

