/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SingleElementIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private boolean m_bHasNext = true;
    private final ELEMENTTYPE m_aElement;

    public SingleElementIterator(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_aElement = ELEMENTTYPE;
    }

    @Override
    public boolean hasNext() {
        return this.m_bHasNext;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_bHasNext) {
            this.m_bHasNext = false;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementIterator singleElementIterator = (SingleElementIterator)object;
        return this.m_bHasNext == singleElementIterator.m_bHasNext && EqualsHelper.equals(this.m_aElement, singleElementIterator.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasNext).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasNext", this.m_bHasNext).append("element", this.m_aElement).getToString();
    }

    @Nonnull
    public static <T> Iterator<T> create(@Nullable T t) {
        return new SingleElementIterator<T>(t);
    }
}

