/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.ICommonsList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommonsArrayList<ELEMENTTYPE>
extends ArrayList<ELEMENTTYPE>
implements ICommonsList<ELEMENTTYPE> {
    public CommonsArrayList() {
    }

    public CommonsArrayList(@Nonnegative int n) {
        super(n);
    }

    public CommonsArrayList(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        super(CollectionHelper.getSize(collection));
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public CommonsArrayList(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        this.addAll(iterable);
    }

    public <SRCTYPE> CommonsArrayList(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(CollectionHelper.getSize(collection));
        this.addAllMapped(collection, function);
    }

    public <SRCTYPE> CommonsArrayList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.addAllMapped(iterable, function);
    }

    public CommonsArrayList(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        super(1);
        this.add(ELEMENTTYPE);
    }

    @SafeVarargs
    public CommonsArrayList(ELEMENTTYPE ... ELEMENTTYPEArray) {
        super(ArrayHelper.getSize(ELEMENTTYPEArray));
        this.addAll(ELEMENTTYPEArray);
    }

    public <SRCTYPE> CommonsArrayList(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(ArrayHelper.getSize(SRCTYPEArray));
        this.addAllMapped(SRCTYPEArray, function);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <T> CommonsArrayList<T> createInstance() {
        return new CommonsArrayList<ELEMENTTYPE>();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CommonsArrayList<ELEMENTTYPE> getClone() {
        return new CommonsArrayList<CommonsArrayList>(this);
    }
}

