/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.IByteArrayEncoder;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

@FunctionalInterface
public interface IByteArrayStreamEncoder
extends IByteArrayEncoder {
    @Override
    @Nonnegative
    default public int getEncodedLength(@Nonnegative int n) {
        return n;
    }

    public void encode(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3, @Nonnull @WillNotClose OutputStream var4);

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public byte[] getEncoded(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.getEncoded(byArray, 0, byArray.length);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public byte[] getEncoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getEncodedLength(n2));){
            this.encode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public byte[] getEncoded(@Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getEncoded(byArray);
    }

    @Nullable
    default public String getEncodedAsString(@Nullable byte[] byArray, @Nonnull Charset charset) {
        if (byArray == null) {
            return null;
        }
        return this.getEncodedAsString(byArray, 0, byArray.length, charset);
    }

    @Nullable
    default public String getEncodedAsString(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getEncodedLength(n2));){
            this.encode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            String string = nonBlockingByteArrayOutputStream.getAsString(charset);
            return string;
        }
    }

    @Nullable
    default public String getEncodedAsString(@Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getEncodedAsString(byArray, 0, byArray.length, charset);
    }
}

