/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.WrappedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingPushbackInputStream
extends WrappedInputStream {
    protected byte[] m_aBuf;
    protected int m_nBufPos;

    public NonBlockingPushbackInputStream(@Nonnull InputStream inputStream, @Nonnegative int n) {
        super(inputStream);
        ValueEnforcer.isGT0(n, "Size");
        this.m_aBuf = new byte[n];
        this.m_nBufPos = n;
    }

    public NonBlockingPushbackInputStream(@Nonnull InputStream inputStream) {
        this(inputStream, 1);
    }

    private void _ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    @Nonnegative
    public int getUnreadCount() {
        return this.m_aBuf.length - this.m_nBufPos;
    }

    public boolean hasUnreadBytes() {
        return this.m_nBufPos < this.m_aBuf.length;
    }

    @Override
    public int read() throws IOException {
        this._ensureOpen();
        if (this.m_nBufPos < this.m_aBuf.length) {
            return this.m_aBuf[this.m_nBufPos++] & 0xFF;
        }
        return super.read();
    }

    @Override
    public int read(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this._ensureOpen();
        if (n2 == 0) {
            return 0;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = this.m_aBuf.length - this.m_nBufPos;
        if (n5 > 0) {
            if (n4 < n5) {
                n5 = n4;
            }
            System.arraycopy(this.m_aBuf, this.m_nBufPos, byArray, n3, n5);
            this.m_nBufPos += n5;
            n3 += n5;
            n4 -= n5;
        }
        if (n4 > 0) {
            if ((n4 = super.read(byArray, n3, n4)) == -1) {
                return n5 == 0 ? -1 : n5;
            }
            return n5 + n4;
        }
        return n5;
    }

    public void unread(int n) throws IOException {
        this._ensureOpen();
        if (this.m_nBufPos == 0) {
            throw new IOException("Push back buffer is full");
        }
        this.m_aBuf[--this.m_nBufPos] = (byte)n;
    }

    public void unread(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this._ensureOpen();
        if (n2 > this.m_nBufPos) {
            throw new IOException("Push back buffer is full");
        }
        this.m_nBufPos -= n2;
        System.arraycopy(byArray, n, this.m_aBuf, this.m_nBufPos, n2);
    }

    public void unread(@Nonnull byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    @Override
    public int available() throws IOException {
        this._ensureOpen();
        return this.m_aBuf.length - this.m_nBufPos + super.available();
    }

    @Override
    public long skip(long l) throws IOException {
        ValueEnforcer.isGE0(l, "SkipValue");
        this._ensureOpen();
        if (l == 0L) {
            return 0L;
        }
        long l2 = l;
        int n = this.m_aBuf.length - this.m_nBufPos;
        if (n > 0) {
            if (l2 <= (long)n) {
                this.m_nBufPos = (int)((long)this.m_nBufPos + l2);
                return l2;
            }
            this.m_nBufPos = this.m_aBuf.length;
            l2 -= (long)n;
        }
        return (long)n + super.skip(l2);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            this.m_aBuf = null;
        }
    }
}

