/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.IWriteToStream;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class NonBlockingByteArrayOutputStream
extends OutputStream
implements IHasSize,
IWriteToStream,
Serializable {
    protected byte[] m_aBuf;
    protected int m_nCount;

    public NonBlockingByteArrayOutputStream() {
        this(32);
    }

    public NonBlockingByteArrayOutputStream(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Size");
        this.m_aBuf = new byte[n];
    }

    @Nonnull
    private static byte[] _enlarge(@Nonnull byte[] byArray, @Nonnegative int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    @Override
    public void write(int n) {
        int n2 = this.m_nCount + 1;
        if (n2 > this.m_aBuf.length) {
            this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n2));
        }
        this.m_aBuf[this.m_nCount] = (byte)n;
        this.m_nCount = n2;
    }

    @Override
    public void write(@Nonnull byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(@Nonnull byte[] byArray, int n, int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        if (n2 > 0) {
            int n3 = this.m_nCount + n2;
            if (n3 > this.m_aBuf.length) {
                this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n3));
            }
            System.arraycopy(byArray, n, this.m_aBuf, this.m_nCount, n2);
            this.m_nCount = n3;
        }
    }

    @Override
    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        outputStream.write(this.m_aBuf, 0, this.m_nCount);
    }

    public void readFrom(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        while (true) {
            int n;
            if (this.m_nCount == this.m_aBuf.length) {
                this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, this.m_aBuf.length << 1);
            }
            if ((n = inputStream.read(this.m_aBuf, this.m_nCount, this.m_aBuf.length - this.m_nCount)) < 0) {
                return;
            }
            this.m_nCount += n;
        }
    }

    public void reset() {
        this.m_nCount = 0;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] toByteArray() {
        return ArrayHelper.getCopy(this.m_aBuf, this.m_nCount);
    }

    public byte getByteAt(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive(n, "Index", 0, this.m_nCount - 1);
        return this.m_aBuf[n];
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.m_nCount;
    }

    @Nonnegative
    public int getBufferSize() {
        return this.m_aBuf.length;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nCount == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_nCount > 0;
    }

    public boolean startsWith(@Nonnull byte[] byArray) {
        return this.startsWith(byArray, 0, byArray.length);
    }

    public boolean startsWith(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_nCount < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.m_aBuf[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public String getAsString(@Nonnull Charset charset) {
        byte[] byArray = this.m_aBuf;
        int n = this.m_nCount;
        return new String(byArray, 0, n, charset);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n, @Nonnull Charset charset) {
        ValueEnforcer.isBetweenInclusive(n, "Length", 0, this.m_nCount);
        byte[] byArray = this.m_aBuf;
        return new String(byArray, 0, n, charset);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        ValueEnforcer.isGE0(n, "Offset");
        ValueEnforcer.isBetweenInclusive(n2, "Length", 0, this.m_nCount);
        byte[] byArray = this.m_aBuf;
        return new String(byArray, n, n2, charset);
    }

    @Nonnull
    @ReturnsMutableObject(value="by design")
    public byte[] directGetBuffer() {
        return this.m_aBuf;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return new ToStringGenerator(this).append("buf#", ArrayHelper.getSize(this.m_aBuf)).append("size", this.m_nCount).getToString();
    }
}

