/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize.write;

import com.helger.commons.string.StringHelper;
import com.helger.commons.xml.EXMLVersion;
import com.helger.commons.xml.XMLHelper;
import com.helger.commons.xml.namespace.ComparatorQName;
import com.helger.commons.xml.serialize.write.AbstractXMLSerializer;
import com.helger.commons.xml.serialize.write.EXMLSerializeBracketMode;
import com.helger.commons.xml.serialize.write.EXMLSerializeIndent;
import com.helger.commons.xml.serialize.write.IXMLWriterSettings;
import com.helger.commons.xml.serialize.write.XMLEmitter;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLSerializer
extends AbstractXMLSerializer<Node> {
    public XMLSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        super(iXMLWriterSettings);
    }

    @Override
    protected void emitNode(@Nonnull XMLEmitter xMLEmitter, @Nullable Node node, @Nullable Node node2, @Nonnull Node node3, @Nullable Node node4) {
        short s = node3.getNodeType();
        if (s == 1) {
            this._writeElement(xMLEmitter, node, node2, (Element)node3, node4);
        } else if (s == 3) {
            XMLSerializer._writeText(xMLEmitter, (Text)node3);
        } else if (s == 4) {
            XMLSerializer._writeCDATA(xMLEmitter, (CDATASection)node3);
        } else if (s == 8) {
            this._writeComment(xMLEmitter, (Comment)node3);
        } else if (s == 5) {
            XMLSerializer._writeEntityReference(xMLEmitter, (EntityReference)node3);
        } else if (s == 9) {
            this._writeDocument(xMLEmitter, (Document)node3);
        } else if (s == 10) {
            this._writeDocumentType(xMLEmitter, (DocumentType)node3);
        } else if (s == 7) {
            XMLSerializer._writeProcessingInstruction(xMLEmitter, (ProcessingInstruction)node3);
        } else {
            throw new IllegalArgumentException("Passed node type " + s + " is not yet supported");
        }
    }

    private void _writeNodeList(@Nonnull XMLEmitter xMLEmitter, @Nonnull Node node, @Nonnull NodeList nodeList) {
        int n = nodeList.getLength() - 1;
        for (int i = 0; i <= n; ++i) {
            this.emitNode(xMLEmitter, node, i == 0 ? null : nodeList.item(i - 1), nodeList.item(i), i == n ? null : nodeList.item(i + 1));
        }
    }

    private void _writeDocument(@Nonnull XMLEmitter xMLEmitter, @Nonnull Document document) {
        if (this.m_aSettings.getSerializeXMLDeclaration().isEmit()) {
            String string = null;
            boolean bl = false;
            try {
                string = document.getXmlVersion();
                bl = document.getXmlStandalone();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EXMLVersion eXMLVersion = EXMLVersion.getFromVersionOrDefault(string, this.m_aSettings.getXMLVersion());
            xMLEmitter.onXMLDeclaration(eXMLVersion, this.m_aSettings.getCharset(), bl || document.getDoctype() == null);
        }
        this._writeNodeList(xMLEmitter, document, document.getChildNodes());
    }

    private void _writeDocumentType(@Nonnull XMLEmitter xMLEmitter, @Nonnull DocumentType documentType) {
        if (this.m_aSettings.getSerializeDocType().isEmit()) {
            xMLEmitter.onDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull XMLEmitter xMLEmitter, @Nonnull ProcessingInstruction processingInstruction) {
        xMLEmitter.onProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    private static void _writeEntityReference(@Nonnull XMLEmitter xMLEmitter, @Nonnull EntityReference entityReference) {
        xMLEmitter.onEntityReference(entityReference.getNodeName());
    }

    private void _writeComment(@Nonnull XMLEmitter xMLEmitter, @Nonnull Comment comment) {
        if (this.m_aSettings.getSerializeComments().isEmit()) {
            xMLEmitter.onComment(comment.getData());
        }
    }

    private static void _writeText(@Nonnull XMLEmitter xMLEmitter, @Nonnull Text text) {
        xMLEmitter.onText(text.getData(), true);
    }

    private static void _writeCDATA(@Nonnull XMLEmitter xMLEmitter, @Nonnull Text text) {
        xMLEmitter.onCDATA(text.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull XMLEmitter xMLEmitter, @Nullable Node node, @Nullable Node node2, @Nonnull Element element, @Nullable Node node3) {
        String string = element.getLocalName() != null ? element.getLocalName() : element.getTagName();
        Document document = element.getOwnerDocument();
        boolean bl = this.m_aSettings.isEmitNamespaces();
        NodeList nodeList = element.getChildNodes();
        boolean bl2 = nodeList.getLength() > 0;
        boolean bl3 = document != null && element.equals(document.getDocumentElement());
        boolean bl4 = node2 == null || !XMLHelper.isInlineNode(node2) || bl3;
        boolean bl5 = node3 == null || !XMLHelper.isInlineNode(node3);
        boolean bl6 = bl2 && !XMLHelper.isInlineNode(element.getFirstChild());
        TreeMap<QName, String> treeMap = new TreeMap<QName, String>(new ComparatorQName());
        this.m_aNSStack.push();
        this.handlePutNamespaceContextPrefixInRoot(treeMap);
        try {
            Object object;
            Object object2;
            Object object3;
            String string2;
            Object object4;
            String string3 = null;
            String string4 = null;
            if (bl) {
                string3 = StringHelper.getNotNull(element.getNamespaceURI());
                string4 = this.m_aNSStack.getElementNamespacePrefixToUse(string3, bl3, treeMap);
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object4 = (Attr)namedNodeMap.item(i);
                string2 = StringHelper.getNotNull(object4.getNamespaceURI());
                if ("http://www.w3.org/2000/xmlns/".equals(string2)) continue;
                object3 = object4.getLocalName() != null ? object4.getLocalName() : object4.getName();
                object2 = object4.getValue();
                object = null;
                if (bl) {
                    object = this.m_aNSStack.getAttributeNamespacePrefixToUse(string2, (String)object3, (String)object2, treeMap);
                }
                if (object != null) {
                    treeMap.put(new QName(string2, (String)object3, (String)object), (String)object2);
                    continue;
                }
                treeMap.put(new QName(string2, (String)object3), (String)object2);
            }
            Element element2 = node != null && node.getNodeType() == 1 ? (Element)node : null;
            Object object5 = object4 = element2 != null ? node.getNamespaceURI() : null;
            string2 = element2 != null ? (element2.getLocalName() != null ? element2.getLocalName() : element2.getTagName()) : null;
            object3 = this.m_aSettings.getIndentDeterminator().getIndentOuter((String)object4, string2, string3, string, treeMap, bl2, this.m_aSettings.getIndent());
            object2 = this.m_aSettings.getBracketModeDeterminator().getBracketMode(string3, string, treeMap, bl2);
            if (((EXMLSerializeIndent)object3).isIndent() && this.m_aIndent.length() > 0 && bl4) {
                xMLEmitter.onContentElementWhitespace(this.m_aIndent);
            }
            xMLEmitter.onElementStart(string4, string, treeMap, bl2, (EXMLSerializeBracketMode)object2);
            if (bl2) {
                object = this.m_aSettings.getIndentDeterminator().getIndentInner((String)object4, string2, string3, string, treeMap, bl2, this.m_aSettings.getIndent());
                if (((EXMLSerializeIndent)object).isAlign() && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
                }
                String string5 = this.m_aSettings.getIndentationString();
                this.m_aIndent.append(string5);
                this._writeNodeList(xMLEmitter, element, nodeList);
                this.m_aIndent.delete(this.m_aIndent.length() - string5.length(), this.m_aIndent.length());
                if (((EXMLSerializeIndent)object).isIndent() && this.m_aIndent.length() > 0 && bl6) {
                    xMLEmitter.onContentElementWhitespace(this.m_aIndent);
                }
            }
            xMLEmitter.onElementEnd(string4, string, bl2, (EXMLSerializeBracketMode)object2);
            if (((EXMLSerializeIndent)object3).isAlign() && bl5) {
                xMLEmitter.onContentElementWhitespace(this.m_aSettings.getNewLineString());
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }
}

