/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope.singleton;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.scope.IGlobalScope;
import com.helger.commons.scope.mgr.ScopeManager;
import com.helger.commons.scope.singleton.AbstractSingleton;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractGlobalSingleton
extends AbstractSingleton {
    protected AbstractGlobalSingleton() {
    }

    @Nonnull
    private static IGlobalScope _getStaticScope(boolean bl) {
        return bl ? ScopeManager.getGlobalScope() : ScopeManager.getGlobalScopeOrNull();
    }

    @Nonnull
    public static final <T extends AbstractGlobalSingleton> T getGlobalSingleton(@Nonnull Class<T> clazz) {
        return (T)((AbstractGlobalSingleton)AbstractGlobalSingleton.getSingleton(AbstractGlobalSingleton._getStaticScope(true), clazz));
    }

    @Nullable
    public static final <T extends AbstractGlobalSingleton> T getGlobalSingletonIfInstantiated(@Nonnull Class<T> clazz) {
        return (T)((AbstractGlobalSingleton)AbstractGlobalSingleton.getSingletonIfInstantiated(AbstractGlobalSingleton._getStaticScope(false), clazz));
    }

    public static final boolean isGlobalSingletonInstantiated(@Nonnull Class<? extends AbstractGlobalSingleton> clazz) {
        return AbstractGlobalSingleton.isSingletonInstantiated(AbstractGlobalSingleton._getStaticScope(false), clazz);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static final List<AbstractGlobalSingleton> getAllGlobalSingletons() {
        return AbstractGlobalSingleton.getAllSingletons(AbstractGlobalSingleton._getStaticScope(false), AbstractGlobalSingleton.class);
    }
}

