/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.ValueEnforcer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CommonsAssert {
    private static final double DOUBLE_ALLOWED_ROUNDING_DIFFERENCE = 0.001;
    private static final CommonsAssert s_aInstance = new CommonsAssert();

    private CommonsAssert() {
    }

    public static void assertEquals(double d, double d2) {
        CommonsAssert.assertEquals((String)null, d, d2);
    }

    public static void assertEquals(double d, Double d2) {
        ValueEnforcer.notNull(d2, "y");
        CommonsAssert.assertEquals((String)null, d, d2);
    }

    public static void assertEquals(@Nullable String string, double d, double d2) {
        if (Double.compare(d, d2) != 0 && Math.abs(d - d2) > 0.001) {
            throw new IllegalArgumentException("<" + d + "> is not equal to <" + d2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }

    public static void assertEquals(float f, float f2) {
        CommonsAssert.assertEquals((String)null, f, f2);
    }

    public static void assertEquals(float f, Float f2) {
        ValueEnforcer.notNull(f2, "y");
        CommonsAssert.assertEquals((String)null, f, f2.floatValue());
    }

    public static void assertEquals(@Nullable String string, float f, float f2) {
        if (Float.compare(f, f2) != 0 && (double)Math.abs(f - f2) > 0.001) {
            throw new IllegalArgumentException("<" + f + "> is not equal to <" + f2 + ">" + (string != null && string.length() > 0 ? ": " + string : ""));
        }
    }
}

